/***************************************************************************
             mreportviewer.h  -  Kugar QT report viewer widget
             -------------------
   begin     : Fri Aug 13 1999
   copyright : (C) 1999 by Mutiny Bay Software
   email     : info@mutinybaysoftware.com
   copyright : (C) 2002 Alexander Dymo
   email     : cloudtemple@mksat.net
***************************************************************************/

#ifndef MREPORTVIEWER_H
#define MREPORTVIEWER_H

#include <tqapplication.h>
#include <tqwidget.h>
#include <tqscrollview.h>
#include <tqpixmap.h>
#include <tqpainter.h>
#include <tqpaintdevicemetrics.h>
#include <tqprogressdialog.h>
#include <tqguardedptr.h>
#include <koffice_export.h>
#include "mreportengine.h"
#include "mpagecollection.h"
#include "mpagedisplay.h"

#define M_PROGRESS_DELAY 500            // Number of ms to delay progress dialog display

class KPrinter;

/** Application reference, required for event processing */
extern TQApplication *mAppRef;

/**Kugar QT report viewer widget
  *@author Mutiny Bay Software
  */

namespace Kugar
{

class KUGAR_EXPORT MReportViewer : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:
    MReportViewer( TQWidget *parent = 0, const char *name = 0 );
    MReportViewer( MReportEngine* engine, TQWidget *parent = 0, const char *name = 0 );
    virtual ~MReportViewer();

    bool setReportData( const TQString & );
    bool setReportData( TQIODevice * );
    bool setReportTemplate( const TQString & );
    bool setReportTemplate( TQIODevice * );
    bool renderReport();
    void clearReport();
    void printReport();
    void printReport( KPrinter &printer );
    void setupPrinter( KPrinter &printer );
    void printReportSilent( int printFrom = -1, int printTo = -1, int printCopies = -1, TQString printerName = TQString() );

    TQSize sizeHint() const;

public slots:
    void slotFirstPage();
    void slotNextPage();
    void slotPrevPage();
    void slotLastPage();

signals:
    void preferedTemplate( const TQString & );

private slots:
    void slotCancelPrinting();
    void slotRenderProgress( int );

protected:
    void paintEvent( TQPaintEvent *event );
    void resizeEvent( TQResizeEvent *event );

    TQScrollView *scroller;
    MPageDisplay *display;
    MReportEngine *rptEngine;
    TQGuardedPtr<MPageCollection> report;
    KPrinter *printer;

private:
    TQProgressDialog* progress;
    int totalSteps;
    void init();
};

}

#endif
