/* This file is part of the KDE project
   Copyright (C) 1999-2005 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __kspread_dlg_find__
#define __kspread_dlg_find__


#include <kfinddialog.h>
#include <tqstringlist.h>
#include <kreplacedialog.h>

class TQCheckBox;
class TQPushButton;
class TQComboBox;

namespace KSpread
{

class FindOption : public TQObject
{
  Q_OBJECT
  TQ_OBJECT
 public:
    FindOption( TQWidget *parent);
    bool searchInAllSheet() const;

    enum searchTypeValue { Value, Note};
    enum searchDirectionValue { Row, Column};

    searchTypeValue searchType() const;
    searchDirectionValue searchDirection() const;

private slots:
    void slotMoreOptions();

signals:
    void adjustSize();

private:
    TQPushButton *m_moreOptions;
    TQCheckBox *m_searchInAllSheet;
    TQWidget *m_findExtension;
    TQComboBox *m_searchIn;
    TQComboBox *m_searchDirection;
};

class FindDlg : public KFindDialog
{
  Q_OBJECT
  TQ_OBJECT

 public:
    FindDlg( TQWidget *parent = 0, const char *name = 0, long options = 0, const TQStringList &findStrings = TQStringList(), bool hasSelection = false );
    ~FindDlg();
    bool searchInAllSheet() const;
    FindOption::searchTypeValue searchType() const { return m_findOptions->searchType(); }
    FindOption::searchDirectionValue searchDirection() const { return m_findOptions->searchDirection(); }

 private slots:
    void slotAjustSize();
 private:
    FindOption *m_findOptions;
};

class SearchDlg : public KReplaceDialog
{
  Q_OBJECT
  TQ_OBJECT

 public:
    SearchDlg( TQWidget *parent = 0, const char *name = 0, long options = 0, const TQStringList &findStrings = TQStringList(), const TQStringList &replaceStrings = TQStringList(), bool hasSelection = false );
    ~SearchDlg();
    bool searchInAllSheet() const;
    FindOption::searchTypeValue searchType() const { return m_findOptions->searchType(); }

 private slots:
    void slotAjustSize();
 private:
    FindOption *m_findOptions;
};

} // namespace KSpread

#endif
