// -*- Mode: c++; c-basic-offset: 4; indent-tabs-mode: nil; tab-width: 4; -*-
/* This file is part of the KDE project
   Copyright (C) 2005 Thomas Zander <zander@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; version 2.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/
#include <tqtoolbutton.h>
#include <tqslider.h>
#include <tqgroupbox.h>
#include <tqlayout.h>
#include <tqbuttongroup.h>
#include <tqobject.h>
#include <tqevent.h>

#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>
#include <knuminput.h>

#include "KPrRotationDialogImpl.h"
#include "rotationpropertyui.h"
#include "KPrTextPreview.h"

KPrRotationDialogImpl::KPrRotationDialogImpl( TQWidget *parent, const char* name )
: KDialogBase( parent, name, true, i18n( "Rotation"), Ok|Cancel|Apply, Ok, true )
, m_dialog( new RotationPropertyUI( this, name ) )
{
    noSignals = false;
    m_preview = new KPrTextPreview( m_dialog->previewPanel );
    TQHBoxLayout *lay = new TQHBoxLayout( m_dialog->previewPanel, m_dialog->previewPanel->lineWidth(), 0 );
    lay->addWidget( m_preview );

    TQHBoxLayout *hbox = new TQHBoxLayout(m_dialog->angleFrame);
    m_angleGroup = new KPrCircleGroup(m_dialog->angleFrame);
    hbox->addWidget(m_angleGroup);

    // Draw the circle of checkboxes.
    TQGridLayout *circleLayout = new TQGridLayout(m_angleGroup, 4, 5);
    circleLayout->addItem(new TQSpacerItem ( 1, 1 , TQSizePolicy::MinimumExpanding ), 0, 0);
    circleLayout->addItem(new TQSpacerItem ( 1, 1 , TQSizePolicy::MinimumExpanding ), 0, 5);
    KPrCircleToggle *r0 = new KPrCircleToggle(m_angleGroup, "tm", 0);
    KPrCircleToggle *r45 = new KPrCircleToggle(m_angleGroup, "tr", 45);
    KPrCircleToggle *r90 = new KPrCircleToggle(m_angleGroup, "mr", 90);
    KPrCircleToggle *r135 = new KPrCircleToggle(m_angleGroup, "br", 135);
    KPrCircleToggle *r180 = new KPrCircleToggle(m_angleGroup, "bm", 180);
    KPrCircleToggle *r225 = new KPrCircleToggle(m_angleGroup, "bl", -135);
    KPrCircleToggle *r270 = new KPrCircleToggle(m_angleGroup, "ml", -90);
    KPrCircleToggle *r315 = new KPrCircleToggle(m_angleGroup, "tl", -45);
    circleLayout->addWidget(r0, 0, 2);
    circleLayout->addWidget(r180, 2, 2);
    circleLayout->addWidget(r45, 0, 3);
    circleLayout->addWidget(r135, 2, 3);
    circleLayout->addWidget(r315, 0, 1);
    circleLayout->addWidget(r225, 2, 1);
    circleLayout->addWidget(r90, 1, 3);
    circleLayout->addWidget(r270, 1, 1);

    connect( m_angleGroup, TQT_SIGNAL (clicked (int)),
             this, TQT_SLOT( angleMode( int ) ) );
    connect (m_dialog->angleSlider, TQT_SIGNAL( valueChanged (int ) ),
             this, TQT_SLOT( angleMode( int ) ) );
    connect (m_dialog->angleSpinbox, TQT_SIGNAL (valueChanged (double) ),
             this, TQT_SLOT( angleChanged( double ) ) );
    connect( this, TQT_SIGNAL( okClicked() ), this, TQT_SLOT( slotOk() ) );

    setMainWidget( m_dialog );
}

void KPrRotationDialogImpl::slotOk()
{
    emit apply();
    accept();
}

void KPrRotationDialogImpl::setAngle( double angle )
{
    if(noSignals) return;
    noSignals = true;
    int roundedAngle = (int) (angle + (angle >=0 ? 0.5:-0.5));
    m_dialog->angleSlider->setValue( roundedAngle );
    if(roundedAngle == -180)
        roundedAngle = 180;
    m_angleGroup->setAngle(roundedAngle);
    m_dialog->angleSpinbox->setValue( angle );
    m_preview->setAngle( angle );
    noSignals = false;
}

double KPrRotationDialogImpl::angle()
{
    return m_dialog->angleSpinbox->value();
}

void KPrRotationDialogImpl::angleChanged( double angle )
{
    setAngle( angle );
}

void KPrRotationDialogImpl::angleMode( int angle )
{
    setAngle( angle );
}


KPrCircleToggle::KPrCircleToggle( TQWidget *parent, const TQString &image, int id )
    : TQLabel( parent )
{
    KIconLoader il("kpresenter");
    m_off = il.loadIcon("rotate/" + image, KIcon::NoGroup, 28);
    m_on = il.loadIcon("rotate/" + image + "dn", KIcon::NoGroup, 28);

    m_selected = false;
    m_id = id;
    setMouseTracking(true);
    setPixmap( m_off );
    KPrCircleGroup *cg = dynamic_cast<KPrCircleGroup*> (parent);
    if(cg != 0)
        cg->add(this);
}

void KPrCircleToggle::mousePressEvent ( TQMouseEvent * e ) {
    if(e->button() != Qt:: LeftButton)
        return;
    setChecked(!m_selected);
}

void KPrCircleToggle::setChecked(bool on) {
    if(on == m_selected) return;
    m_selected = on;
    setPixmap( m_selected?m_on:m_off );
    emit clicked(m_id);
}

KPrCircleGroup::KPrCircleGroup(TQWidget *parent)
    : TQFrame(parent), m_buttons()
{
    noSignals=false;
}

void KPrCircleGroup::setAngle(int angle) {
    noSignals = true;
    KPrCircleToggle *button;
    for ( button = m_buttons.first(); button; button = m_buttons.next() )
        button->setChecked(angle == button->id());
    noSignals = false;
}

void KPrCircleGroup::add(KPrCircleToggle *button) {
    connect (button, TQT_SIGNAL(clicked (int)), this, TQT_SLOT (selectionChanged (int)) );
    m_buttons.append(button);
}

void KPrCircleGroup::selectionChanged(int buttonId) {
    if(noSignals)
        return;
    KPrCircleToggle *button;
    for ( button = m_buttons.first(); button; button = m_buttons.next() )
        button->setChecked(buttonId == button->id());
    emit clicked(buttonId);
}

#include "KPrRotationDialogImpl.moc"
