/* This file is part of the KDE project
   Copyright (C) 2004 Dag Andersen <danders@get2net.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation;
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KPTCALENDAREDITBASE_H
#define KPTCALENDAREDITBASE_H

#include <tqvariant.h>
#include <tqwidget.h>

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQGroupBox;
class TQLabel;
class TQComboBox;
class TQButtonGroup;
class TQPushButton;
class TQListView;
class TQListViewItem;
class TQTimeEdit;

namespace KPlato
{

class CalendarPanel;

class CalendarEditBase : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:
    CalendarEditBase( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~CalendarEditBase();

    TQGroupBox* groupBox2;
    CalendarPanel* calendarPanel;
    TQButtonGroup* day;
    TQComboBox* state;
    TQPushButton* bApply;
    TQGroupBox* groupBox4;
    TQListView* intervalList;
    TQTimeEdit* startTime;
    TQTimeEdit* endTime;
    TQPushButton* bClear;
    TQPushButton* bAddInterval;

protected:
    TQHBoxLayout* CalendarEditBaseLayout;
    TQGridLayout* groupBox2Layout;
    TQHBoxLayout* layout10;
    TQVBoxLayout* dayLayout;
    TQHBoxLayout* layout8;
    TQVBoxLayout* groupBox4Layout;
    TQHBoxLayout* layout6;
    TQHBoxLayout* layout5;

protected slots:
    virtual void languageChange();

};

}  //KPlato namespace

#endif // CALENDAREDITBASE_H
