/* This file is part of the KDE project
   Copyright (C) 2005 Dag Andersen <danders@get2net.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation;
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KPTACCOUNTSPANEL_H
#define KPTACCOUNTSPANEL_H

#include "kptaccountspanelbase.h"

#include <tqptrlist.h>
#include <tqdict.h>

class TQListView;
class TQListViewItem;
class TQWidget;

class KCommand;
class KMacroCommand;

namespace KPlato
{

class AccountItem;
class Account;
class Accounts;
class Part;
class Project;

class AccountsPanel : public AccountsPanelBase {
    Q_OBJECT
  TQ_OBJECT
public:
    AccountsPanel(Accounts &acc, TQWidget *parent=0, const char *name=0);
    
    KCommand *buildCommand(Part *part);
    
    bool isUnique(TQListViewItem *item);
    void renameStopped(TQListViewItem *item);
    
signals:
    void changed(bool);
    
    // Internal
    void renameStarted(TQListViewItem *, int);
    void startRename(TQListViewItem *item, int col);
    void selectionChanged();
    
public slots:
    void slotOk();
    
protected slots:
    void slotChanged();
    void slotSelectionChanged();
    void slotItemRenamed(TQListViewItem *item, int col);
    void slotRemoveBtn();
    void slotNewBtn();
    void slotSubBtn();
    void slotActivated(int);
    void slotListDoubleClicked(TQListViewItem* item, const TQPoint&, int col);
    void slotRenameStarted(TQListViewItem *item, int col);
    void slotStartRename(TQListViewItem *item, int col);
    void slotRemoveItem(TQListViewItem *i);
protected:
    void addItems(TQListView *lv, Accounts &acc);
    void addItems(TQListViewItem *item, Account *acc);
    void addElement(const TQListViewItem *item);
    void removeElement(TQListViewItem *item);
    void refreshDefaultAccount();
    KCommand *save(Part *part, Project &project);
    KCommand *save(Part *part, Project &project, TQListViewItem *item);
    
private:
    Accounts &m_accounts;
    
    TQPtrList<TQListViewItem> m_removedItems;
    Account *m_oldDefaultAccount;
    TQDict<TQListViewItem> m_elements;
    int m_currentIndex;
    TQString m_renameText;
    TQListViewItem *m_renameItem;
};

} //namespace KPlato

#endif
