#ifndef KIVIO_TEXT_STYLE_H
#define KIVIO_TEXT_STYLE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqfont.h>

class TQDomDocument;
class TQPainter;


class KivioTextStyle
{
protected:
    TQString m_text;                                 // The text inside this shape
    TQColor m_color;                                 // The text color
    TQFont m_font;                                   // The text font
    bool m_isHtml;                                  // Is the text HTML formatted?
    int m_hTextAlign, m_vTextAlign;                 //Qt::Horizontal and vertical text alignment flags

public:
    KivioTextStyle();
    virtual ~KivioTextStyle();

    TQDomElement saveXML( TQDomDocument & );
    bool loadXML( const TQDomElement & );

    void copyInto( KivioTextStyle * );




    inline TQString text() { return m_text; }
    inline void setText( TQString s ) { m_text=s; }

    inline TQColor color() { return m_color; }
    inline void setColor( TQColor c ) { m_color=c; }

    inline TQFont font() { return m_font; }
    inline void setFont( TQFont f ) { m_font=f; }

    inline bool isHtml() { return m_isHtml; }
    inline void setIsHtml( bool b ) { m_isHtml=b; }

    inline int hTextAlign() { return m_hTextAlign; }
    inline void setHTextAlign(int i) { m_hTextAlign=i; }

    inline int vTextAlign() { return m_vTextAlign; }
    inline void setVTextAlign(int i) { m_vTextAlign=i; }

};

#endif

