/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000-2001 theKompany.com & Dave Marotti
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef KIVIO_ICON_VIEW_H
#define KIVIO_ICON_VIEW_H

#include <tqdom.h>
#include <tqiconview.h>
#include <tqptrlist.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqdragobject.h>

class KivioStencilSpawnerSet;
class KivioStencilSpawner;

class KivioIconView : public TQIconView
{
  Q_OBJECT
  TQ_OBJECT
  protected:
    KivioStencilSpawnerSet *m_pSpawnerSet;
    static KivioStencilSpawner *m_pCurDrag;

    TQDragObject *dragObject();

  protected slots:
    void slotDoubleClicked(TQIconViewItem*);
    void slotClicked(TQIconViewItem* item);

  signals:
    void createNewStencil(KivioStencilSpawner * );
    void stencilSelected(KivioStencilSpawner*);

  public:
    KivioIconView( bool _readWrite,TQWidget *parent=0, const char *name=0 );
    virtual ~KivioIconView();

    static void clearCurrentDrag();
    static KivioStencilSpawner *curDragSpawner() { return m_pCurDrag; }

    void setStencilSpawnerSet(KivioStencilSpawnerSet*);
    KivioStencilSpawnerSet *spawnerSet() { return m_pSpawnerSet; }

  private:
    static TQPtrList<KivioIconView> objList;
    bool isReadWrite;
};

class KivioIconViewItem : public TQIconViewItem
{
  friend class KivioIconView;

  protected:
    KivioStencilSpawner *m_pSpawner;

  public:
    KivioIconViewItem( TQIconView *parent );
    virtual ~KivioIconViewItem();

    void setStencilSpawner(KivioStencilSpawner*);
    KivioStencilSpawner *spawner() { return m_pSpawner; }

    virtual bool acceptDrop( const TQMimeSource *e ) const;
};


#endif

