/* This file is part of the KDE project
   Copyright (C) 2005 Cedric Pasteur <cedric.pasteur@free.fr>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXIFLOWLAYOUT_H
#define KEXIFLOWLAYOUT_H

#include <tqlayout.h>
#include <tqptrlist.h>

//! @short a special "flow" layout
class KEXIGUIUTILS_EXPORT KexiFlowLayout : public TQLayout
{
	public:
		KexiFlowLayout(TQWidget *parent, int border=0, int space=-1, const char *name=0);
		KexiFlowLayout(TQLayout* parent, int space=-1, const char *name=0);
		KexiFlowLayout(int space=-1, const char *name=0);

		~KexiFlowLayout();

		/*! \return the widgets in the order of the layout,
		 ie as it is stored in m_list. You must delete the list after using it. */
		TQPtrList<TQWidget>* widgetList() const;

		/*! Sets layout's orientation to \a orientation. Default orientation isQt::Vertical. */
		void  setOrientation(Qt::Orientation orientation) { m_orientation = orientation; }

		/*! \return layout's orientation. */
		Qt::Orientation orientation() const { return m_orientation; }

		void setJustified(bool justify) { m_justify = justify; }
		bool isJustified() const { return m_justify; }

		virtual void addItem(TQLayoutItem *item);
		virtual void addSpacing(int size);
		virtual TQLayoutIterator iterator();
		virtual void  invalidate();

		virtual bool hasHeightForWidth() const;
		virtual int heightForWidth(int width) const;
		virtual TQSize sizeHint() const;
		virtual TQSize minimumSize() const;
		virtual TQSizePolicy::ExpandData expanding() const;

		virtual bool isEmpty();

#ifdef USE_QT4
		QLAYOUT_REQUIRED_METHOD_DECLARATIONS
#endif // USE_QT4

	protected:
		virtual void setGeometry(const TQRect&);
		int simulateLayout(const TQRect &r);
		int doHorizontalLayout(const TQRect&, bool testonly = false);
		int doVerticalLayout(const TQRect&, bool testonly = false);

	private:
		TQPtrList<TQLayoutItem> m_list;
		int m_cached_width;
		int m_cached_hfw;
		bool m_justify;
		Qt::Orientation m_orientation;
		TQSize m_cached_sizeHint;
		TQSize m_cached_minSize;
};

#endif

