/* This file is part of the KDE project
   Copyright (C) 2005-2006 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and,or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXITABLEVIEWHEADER_H
#define KEXITABLEVIEWHEADER_H

#include <tqheader.h>

class TQStyle;

//! @short A table view header with additional actions.
/*! Displays field description (Field::description()) text as tool tip, if available.
 Displays tool tips if a pointed section is not wide enough to fit its label text.

 \todo react on indexChange ( int section, int fromIndex, int toIndex ) signal
*/
class KEXIDATATABLE_EXPORT KexiTableViewHeader : public TQHeader
{
	Q_OBJECT
  TQ_OBJECT

	public:
		KexiTableViewHeader(TQWidget * parent = 0, const char * name = 0);

		virtual ~KexiTableViewHeader();

		int addLabel( const TQString & s, int size = -1 );

		int addLabel( const TQIconSet & iconset, const TQString & s, int size = -1 );

		void removeLabel( int section );

		/*! Sets \a toolTip for \a section. */
		void setToolTip( int section, const TQString & toolTip );

		virtual bool eventFilter(TQObject * watched, TQEvent * e);

		void setSelectedSection(int section);
		int selectedSection() const;

		TQColor selectionBackgroundColor() const;
		void setSelectionBackgroundColor(const TQColor &color);

	protected slots:
		void slotSizeChange(int section, int oldSize, int newSize );

	protected:
		virtual void paintSection ( TQPainter * p, int index, const TQRect & fr );
		virtual void styleChange( TQStyle& oldStyle );

		int m_lastToolTipSection;
		TQRect m_toolTipRect;

		TQStringList m_toolTips;
		TQColor m_selectionBackgroundColor;
		int m_selectedSection;
		bool m_styleChangeEnabled : 1;
};

#endif
