/***************************************************************************
 * kexidbconnectiondata.h
 * This file is part of the KDE project
 * copyright (C)2004-2005 by Sebastian Sauer (mail@dipe.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef KROSS_KEXIDB_KEXIDBCONNECTIONDATA_H
#define KROSS_KEXIDB_KEXIDBCONNECTIONDATA_H

#include <tqstring.h>

#include <api/object.h>
#include <api/variant.h>
#include <api/list.h>
#include <api/class.h>

#include <kexidb/connection.h>
#include <kexidb/connectiondata.h>

namespace Kross { namespace KexiDB {

    /**
     * A KexiDBConnectionData is used to store the details needed for
     * a connection with a database.
     */
    class KexiDBConnectionData : public Kross::Api::Class<KexiDBConnectionData>
    {
            friend class KexiDBDriverManager;
        public:
            KexiDBConnectionData(::KexiDB::ConnectionData* data);
            virtual ~KexiDBConnectionData();
            operator ::KexiDB::ConnectionData& () { return *m_data; }
            operator ::KexiDB::ConnectionData* () { return m_data; }
            virtual const TQString getClassName() const;
            ::KexiDB::ConnectionData* data() { return m_data; }

        private:

            /** Return the connection name. */
            const TQString caption() const;
            /** Set the connection name. */
            void setCaption(const TQString& name);

            /** Return the description. */
            const TQString description() const;
            /** Set the description. */
            void setDescription(const TQString& desc);

            /** Return drivername. */
            const TQString driverName() const;
            /** Set the drivername. */
            void setDriverName(const TQString& driver);

            /** Return true if a local socket file is used else false. */
            bool localSocketFileUsed() const;
            /** Set if the local socket file should be used. */
            void setLocalSocketFileUsed(bool used);
            /** Return the local socket filename. */
            const TQString localSocketFileName() const;
            /** Set the local socket filename. */
            void setLocalSocketFileName(const TQString& socketfilename);

            // For serverbased drivers

            /** Return the database name. */
            const TQString databaseName() const;
            /** Set the database name. */
            void setDatabaseName(const TQString& dbname);

            /** Return the hostname. */
            const TQString hostName() const;
            /** Set the hostname. */
            void setHostName(const TQString& hostname);

            /** Return the port number. */
            int port() const;
            /** Set the port number. */
            void setPort(int p);

            /** Return the password. */
            const TQString password() const;
            /** Set the password. */
            void setPassword(const TQString& passwd);

            /** Return the username. */
            const TQString userName() const;
            /** Set the username. */
            void setUserName(const TQString& username);

            // For filebased drivers

            /** Return the filename. */
            const TQString fileName() const;
            /** Set the filename. */
            void setFileName(const TQString& filename);

            /** Return the database path. */
            const TQString dbPath() const;
            /** Return the database filename. */
            const TQString dbFileName() const;

            /** Return a user-friendly string representation. */
            const TQString serverInfoString() const;

        private:
            ::KexiDB::ConnectionData* m_data;
            TQString m_dbname;
    };

}}

#endif

