/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXIREPORTWIDGETS_H
#define KEXIREPORTWIDGETS_H

#include <tqlabel.h>
#include <tqscrollview.h>

namespace KFormDesigner {
	class Form;
	class FormManager;
}

using KFormDesigner::Form;

//! A form embedded as a widget inside other form
class KexiSubReport : public TQScrollView
{
	Q_OBJECT
  TQ_OBJECT
	TQ_PROPERTY(TQString reportName READ reportName WRITE setReportName DESIGNABLE true);

	public:
		KexiSubReport(TQWidget *parent, const char *name);
		~KexiSubReport() {}

		//! \return the name of the subreport inside the db
		TQString reportName() const { return m_reportName; }
		void setReportName(const TQString &name);

	private:
//		KFormDesigner::FormManager *m_manager;
		Form   *m_form;
		TQWidget  *m_widget;
		TQString   m_reportName;
};

//! A simple label inside a report
class Label : public TQLabel
{
	Q_OBJECT
  TQ_OBJECT

	public:
		Label(const TQString &text, TQWidget *parent, const char *name);
		~Label() {}
};

//! A simple picture label inside a report
class PicLabel : public TQLabel
{
	Q_OBJECT
  TQ_OBJECT

	public:
		PicLabel(const TQPixmap &pix, TQWidget *parent, const char *name);
		~PicLabel() {}

		virtual bool setProperty(const char *name, const TQVariant &value);
};

//! A line
class ReportLine : public TQWidget
{
	Q_OBJECT
  TQ_OBJECT
	TQ_PROPERTY(ReportLineStyle lineStyle READ lineStyle WRITE setLineStyle)
	TQ_PROPERTY(int lineWidth READ lineWidth WRITE setLineWidth)
	TQ_PROPERTY(TQColor color READ color WRITE setColor)
	TQ_PROPERTY(CapStyle capStyle READ capStyle WRITE setCapStyle)

	public:
		enum ReportLineStyle { NoLine = TQt::NoPen, Solid = TQt::SolidLine, Dash = TQt::DashLine,  Dot = TQt::DotLine,
			DashDot = TQt::DashDotLine, DashDotDot =  TQt::DashDotDotLine };
		enum CapStyle { Flat = TQt::FlatCap, Square = TQt::SquareCap, Round = TQt::RoundCap };

		ReportLine(TQWidget *parent, const char *name);
		~ReportLine(){;}

		ReportLineStyle lineStyle() const;
		void setLineStyle(ReportLineStyle style);

		int lineWidth() const;
		void setLineWidth(int width);

		TQColor color() const;
		void setColor(const TQColor &color);

		CapStyle capStyle() const;
		void setCapStyle(CapStyle capStyle);

	protected:
		virtual void paintEvent (TQPaintEvent *ev);

	private:
		ReportLineStyle m_lineStyle;
		int m_lineWidth;
		CapStyle m_capStyle;
		TQColor  m_color;
};


#endif

