/* This file is part of the KDE project
   Copyright (C) 2003 Joseph Wenninger <jowenn@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */


#include "kexidynamicqueryparameterdialog.h"
#include "kexidynamicqueryparameterdialog.moc"

#include <tqvbox.h>
#include <klocale.h>
#include <kdebug.h>
#include <tqlineedit.h>
#include <tqobjectlist.h>

KexiDynamicQueryParameterDialog::KexiDynamicQueryParameterDialog(TQWidget *parent,
	KexiDataProvider::Parameters *values, const KexiDataProvider::ParameterList &list):
		KDialogBase(parent, "paramddialog", true, i18n("Query Parameters"),
		KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
	m_values=values;
	int y;
	m_mainView=new TQVBox(this);

	for (KexiDataProvider::ParameterList::const_iterator it=list.begin();
		it!=list.end();++it) {
		TQLineEdit *le=new TQLineEdit(m_mainView,(*it).name.utf8());
		le->setText((*values)[(*it).name]);
	}

	setMainWidget(m_mainView);
}

KexiDynamicQueryParameterDialog::~KexiDynamicQueryParameterDialog() {}

void KexiDynamicQueryParameterDialog::slotOk() {
	TQObjectList *l=queryList(0,"kexi_.*",true,true);
	TQObjectListIt it(*l);
	TQObject *obj;
	kdDebug()<<"KexiDynamicQueryParameterDialog::slotOk()"<<endl;
	while ((obj=it.current())!=0) {
		kdDebug()<<"KexiDynamicQueryParameterDialog::slotOk()::loop"<<endl;
		(*m_values)[TQString().fromUtf8(obj->name())]=
			(dynamic_cast<TQLineEdit*>(obj))->text();
		++it;
	}
	delete l;
	KDialogBase::slotOk();
}
