/**
 * Kalle Dalheimer <kalle@kde.org>
 */

#ifndef KCHART_PART_H
#define KCHART_PART_H


#include <kconfig.h>

#include <koChart.h>
#include "kchart_params.h"
#include "koffice_export.h"

class KoXmlWriter;
class KoGenStyles;
namespace KChart
{

class KChartParams;


class KCHART_EXPORT KChartPart : public KoChart::Part
{
    Q_OBJECT
  TQ_OBJECT

public:
    KChartPart( TQWidget *parentWidget = 0, const char *widgetName = 0,
		TQObject* parent = 0, const char* name = 0,
		bool singleViewMode = false );
    ~KChartPart();

    // Methods inherited from KoDocument:

    virtual bool  initDoc(InitDocFlags flags, TQWidget* parentWidget=0);

    virtual void  paintContent( TQPainter& painter, const TQRect& rect,
				bool transparent = false,
				double zoomX = 1.0, double zoomY = 1.0 );

    // Methods unique to KChart, and available in the new interface
    // (see ../interfaces/koChart.h.)

    virtual void  resizeData( int rows, int columns );
    virtual void  setCellData( int row, int column, const TQVariant &);
    virtual void  analyzeHeaders( );
    virtual void  setCanChangeValue( bool b )  { m_bCanChangeValue = b;    }

    // ----------------------------------------------------------------

    void  analyzeHeaders( const KDChartTableData& data );
    void  doSetData( const KDChartTableData&  data,
		     bool  firstColHeader,
		     bool  firstRowHeader );

    bool showWizard( TQString &dataArea );
    void initLabelAndLegend();
    void loadConfig(KConfig *conf);
    void saveConfig(KConfig *conf);
    void defaultConfig();

    KChartParams::ChartType  chartType() const { return (KChartParams::ChartType) params()->chartType(); }
    KDChartTableData  *data()                  { return &m_currentData; }
    KChartParams      *params() const          { return m_params;       }

    TQStringList       &rowLabelTexts()         { return m_rowLabels;  }
    TQStringList       &colLabelTexts()         { return m_colLabels;  }

    // Save and load
    virtual TQDomDocument  saveXML();
    virtual bool          loadXML( TQIODevice *, const TQDomDocument& doc );
    virtual bool          loadOasis( const TQDomDocument& doc,
				     KoOasisStyles& oasisStyles,
				     const TQDomDocument& settings,
				     KoStore *store );
    virtual bool          saveOasis( KoStore* store,
                                     KoXmlWriter* manifestWriter );

    bool  canChangeValue()   const             { return m_bCanChangeValue; }

    void  initNullChart();

    // Functions that generate templates (not used yet):
    void  generateBarChartTemplate();

    virtual bool showEmbedInitDialog(TQWidget* parent);

public slots:
    void  slotModified();
    virtual void initEmpty();

signals:
    void docChanged();

protected:
    virtual KoView* createViewInstance( TQWidget* parent, const char* name );
    bool  loadOldXML( const TQDomDocument& doc );
    bool  loadAuxiliary( const TQDomDocument& doc );
    bool  loadData( const TQDomDocument& doc, KDChartTableData& currentData );
    bool  loadOasisData( const TQDomElement& tableElem );
    void  saveOasisData( KoXmlWriter* bodyWriter, KoGenStyles& mainStyles ) const;
    void writeAutomaticStyles( KoXmlWriter& contentWriter, KoGenStyles& mainStyles ) const;

private:
    // Helper methods for painting.
    int          createDisplayData();
    void         createLabelsAndLegend( TQStringList  &longLabels,
					TQStringList  &shortLabels );


    TQDomElement  createElement(const TQString &tagName,
			       const TQFont &font,
			       TQDomDocument &doc) const;
    TQFont        toFont(TQDomElement &element)     const;

    void         setChartDefaults();

private:
    // The chart and its contents
    KChartParams            *m_params;      // Everything about the chart
    KDChartTableData         m_currentData; // The data in the chart.
    TQStringList              m_rowLabels;
    TQStringList              m_colLabels;
    //TQString                  m_regionName;

    // Other auxiliary values
    bool                     m_bCanChangeValue;

    // Graphics
    TQWidget                 *m_parentWidget;

    // Used when displaying.
    KDChartTableData         m_displayData;

    TQPixmap                  m_bufferPixmap;
};


class WizardExt : public KoChart::WizardExtension
{
public:
    WizardExt( KoChart::Part *part )
        : KoChart::WizardExtension( part ) {};

    virtual bool show( TQString &dataArea ) {
        return static_cast<KChartPart *>( part() )->showWizard( dataArea );
    }
};

}  //KChart namespace

#endif
