/* This file is part of the KDE project
   Copyright (C) 2000,2001,2002,2003,2004 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kchartPieConfigPage.h"
#include "kchartPieConfigPage.moc"

#include <kapplication.h>
#include <klocale.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <kfontdialog.h>

#include <tqcheckbox.h>
#include <tqlineedit.h>
#include <tqradiobutton.h>
#include <tqpushbutton.h>
#include <tqfont.h>
#include <tqspinbox.h>

#include "kchart_params.h"


namespace KChart
{

KChartPieConfigPage::KChartPieConfigPage( KChartParams* params,
                                          TQWidget* parent,
                                          KDChartTableData* data) :
    TQWidget( parent ),_params( params )
{
    //    col=_params->colPie;
    pos=-1;
    TQGridLayout *grid = new TQGridLayout(this,10,4,KDialog::marginHint(), 
					KDialog::spacingHint());
    // The listview
    list = new TQListView( this );
    list->resize( list->sizeHint() );
    grid->addMultiCellWidget(list,0,9,0,0);
    list->addColumn( i18n("Hide Piece") );
    list->setRootIsDecorated( TRUE );

    TQLabel* label = new TQLabel( i18n( "Column active:" ), this );
    label->resize( label->sizeHint() );
    grid->addWidget( label,0,1);

    column = new TQSpinBox(1, data->cols(), 1, this);
    column->resize(100, column->sizeHint().height() );
    grid->addWidget( column,1,1);

    column->setValue(col+1);

    label = new TQLabel( i18n( "Move piece to:" ), this );
    label->resize( label->sizeHint() );
    grid->addWidget( label,2,1);

    dist = new TQSpinBox(0, 400, 1, this);
    dist->resize(100, dist->sizeHint().height() );
    grid->addWidget( dist,3,1);

    label = new TQLabel( i18n( "Explode factor (%):" ), this );
    label->resize( label->sizeHint() );
    grid->addWidget( label,4,1);

    explose = new TQSpinBox(0, 100, 1, this);
    explose->resize(100, explose->sizeHint().height() );
    grid->addWidget( explose,5,1);

    grid->addColSpacing(0,list->width());
    grid->addColSpacing(2,list->width());
    grid->addColSpacing(3,list->width());


    initList();
    dist->setEnabled(false);

    connect(column,TQT_SIGNAL(valueChanged(int)),this,TQT_SLOT(changeValue(int)));

    connect( list, TQT_SIGNAL( selectionChanged(TQListViewItem *) ), this, TQT_SLOT( slotselected(TQListViewItem *) ) );
}


void KChartPieConfigPage::initList()
{
    //int index;
    // PENDING(kalle) Put back in
    //     for( TQStringList::Iterator it = _params->legend.begin(); it != _params->legend.end(); ++it ) {
//         (void)new TQCheckListItem( list, (*it),TQCheckListItem::CheckBox ) ;

//     }
    TQListViewItemIterator it( list );
    //Select or not CheckBox
    // PENDING(kalle) Put back in
    //     for( ; it.current(); ++it )	{
//         index = _params->legend.findIndex(((TQCheckListItem*)it.current())->text());
//         ((TQCheckListItem*)it.current())->setOn(_params->missing[_params->legend.count()*col+index]) ;
//     }
//     value.duplicate(_params->explode);
}


void KChartPieConfigPage::slotselected(TQListViewItem */*it*/)
{
    //column : 0
    //cout <<"Select :"<<(it)->text(0).ascii()<<endl;
    // PENDING(kalle) Put back in
    //     int index = _params->legend.findIndex((it)->text(0));
    if(pos==-1)
	dist->setEnabled(true);
    else
	value[pos]=dist->value();

    // PENDING(kalle) Put back in
    //     pos=_params->legend.count()*col+index;
    dist->setValue(value[pos]);
}


void KChartPieConfigPage::changeValue(int val)
{
    col=val-1;
    TQListViewItemIterator it( list );
    //Select or not CheckBox
    ;
    //int index=0;
    for( ; it.current(); ++it )	{
        // PENDING(kalle) Put back in
        //         index = _params->legend.findIndex(((TQCheckListItem*)it.current())->text());
//         ((TQCheckListItem*)it.current())->setOn(_params->missing[_params->legend.count()*col+index]) ;
    }

    if(pos!=-1) {
        value[pos]=dist->value();
        // PENDING(kalle) Put back in
        //         pos=_params->legend.count()*col+index;
        dist->setValue(value[pos]);
    }
}


void KChartPieConfigPage::init()
{
    TQListViewItemIterator it( list );
    //Select or not CheckBox

    //int index = 0;
    for( ; it.current(); ++it )	{
        // PENDING(kalle) Put back in
        //        index = _params->legend.findIndex(((TQCheckListItem*)it.current())->text());
        //         ((TQCheckListItem*)it.current())->setOn(_params->missing[_params->legend.count()*col+index]) ;
    }

    // PENDING(kalle) Put back in
//     value.duplicate(_params->explode);
//     if(pos!=-1) {
//             pos=_params->legend.count()*col;
//             dist->setValue(	value[pos]);
// 	}
    explose->setValue((int)(_params->explodeFactor()*100));
}


void KChartPieConfigPage::apply()
{
    TQListViewItemIterator it( list );
    //Select or not CheckBox
    //int index = 0;
    for( ; it.current(); ++it )	{
        // PENDING(kalle) Put back in
        //         index = _params->legend.findIndex(((TQCheckListItem*)it.current())->text());
//         _params->missing[_params->legend.count()*col+index]=((TQCheckListItem*)it.current())->isOn() ;
    }
    //     _params->colPie=col;

    // PENDING(kalle) Put back in
    //     value[pos]=dist->value();
//     _params->explode.duplicate(value);
    _params->setExplodeFactor(((double)(explose->value()))/100);
}

}  //KChart namespace
