/* This file is part of the KDE project
   Copyright (C) 2001, 2002, 2003 The Karbon Developers

   Original work :
   kis_resourceserver.h - part of KImageShop

   Copyright (c) 1999 Matthias Elter <elter@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __KARBONRESOURCESERVER_H__
#define __KARBONRESOURCESERVER_H__


#include <tqptrlist.h>
#include <tqdict.h>
#include <tqstring.h>

//#include "vgradient.h"
#include "vpattern.h"
#include <koffice_export.h>

class VGradient;
class VGradientListItem;
class VClipartIconItem;
class VObject;


class KARBONCOMMON_EXPORT KarbonResourceServer : public TQObject
{
	Q_OBJECT
  TQ_OBJECT

public:
	KarbonResourceServer();
	virtual ~KarbonResourceServer();

	int patternCount()
	{
		return m_patterns.count();
	}

	TQPtrList<KoIconItem> patterns()
	{
		return m_patterns;
	}

	VPattern* addPattern( const TQString& tilename );
	void removePattern( VPattern* pattern );

	int gradientCount()
	{
		return m_gradients->count();
	}

	TQPtrList<VGradientListItem>* gradients()
	{
		return m_gradients;
	}

	VGradientListItem* addGradient( VGradient* gradient );
	void removeGradient( VGradientListItem* gradient );

	int clipartCount()
	{
		return m_cliparts->count();
	}

	TQPtrList<VClipartIconItem>* cliparts()
	{
		return m_cliparts;
	}

	VClipartIconItem* addClipart( VObject* clipart, double width, double height );
	void removeClipart( VClipartIconItem* clipartIcon );

	TQPixmap *cachePixmap( const TQString &key, int group_or_size );

signals:
	void patternAdded( KoIconItem *pattern );
	void patternRemoved( KoIconItem *pattern );

protected:
	const VPattern* loadPattern( const TQString& filename );

	void loadGradient( const TQString& filename );
	void saveGradient( VGradient* gradient, const TQString& filename );

	void loadClipart( const TQString& filename );
	void saveClipart( VObject* object, double width, double height, const TQString& filename );

private:
	TQPtrList<KoIconItem> m_patterns;
	TQPtrList<VGradientListItem>* m_gradients;
	TQPtrList<VClipartIconItem>* m_cliparts;
	TQDict<TQPixmap> m_pixmaps;
};

class VClipartIconItem : public KoIconItem
{
public:
	VClipartIconItem( const VObject* clipart, double width, double height, TQString filename );
	VClipartIconItem( const VClipartIconItem& item );
	~VClipartIconItem();

	virtual TQPixmap& thumbPixmap() const
	{
		return ( TQPixmap& ) m_thumbPixmap;
	}

	virtual TQPixmap& pixmap() const
	{
		return ( TQPixmap& ) m_pixmap;
	}

	const VObject* clipart() const
	{
		return m_clipart;
	}

	TQString filename() const
	{
		return m_filename;
	}

	bool canDelete() const
	{
		return m_delete;
	}

	double originalWidth() const
	{
		return m_width;
	}

	double originalHeight() const
	{
		return m_height;
	}

	VClipartIconItem* clone();

private:
	TQPixmap m_pixmap;
	TQPixmap m_thumbPixmap;
	VObject* m_clipart;
	TQString m_filename;
	bool m_delete;
	double m_width;
	double m_height;
}

; // VClipartIconItem

#endif

