/* This file is part of the KDE project
   Copyright (C) 2002 Laurent Montel <lmontel@mandrakesoft.com>
   Copyright (C) 2003 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef OoWriter_IMPORT_H__
#define OoWriter_IMPORT_H__

#include <KoFilter.h>

#include <tqdict.h>
#include <tqdom.h>
#include <KoStyleStack.h>
#include <liststylestack.h>

class KZip;

class OoWriterImport : public KoFilter
{
    Q_OBJECT
  TQ_OBJECT
public:
    OoWriterImport( KoFilter * parent, const char * name, const TQStringList & );
    virtual ~OoWriterImport();

    virtual KoFilter::ConversionStatus convert( TQCString const & from, TQCString const & to );

private:
    void prepareDocument( TQDomDocument& mainDocument, TQDomElement& framesetsElem );
    void finishDocumentContent( TQDomDocument& mainDocument );
    void writePageLayout( TQDomDocument& mainDocument, const TQString& masterPageName );
    void parseList( TQDomDocument& doc, const TQDomElement& list, TQDomElement& currentFramesetElement );
    bool pushListLevelStyle( const TQString& listStyleName, int level );
    bool pushListLevelStyle( const TQString& listStyleName, TQDomElement& fullListStyle, int level );
    void applyListStyle( TQDomDocument& doc, TQDomElement& layoutElement, const TQDomElement& paragraph );
    void writeCounter( TQDomDocument& doc, TQDomElement& layoutElement, bool heading, int level, bool ordered );
    TQDomElement parseParagraph( TQDomDocument& doc, const TQDomElement& paragraph );
    void parseSpanOrSimilar( TQDomDocument& doc, const TQDomElement& parent, TQDomElement& kwordParagraph, TQDomElement& kwordFormats, TQString& paragraphText, uint& pos);
    // Reads from m_styleStack, writes the text properties to parentElement
    void writeFormat( TQDomDocument& doc, TQDomElement& parentElement, int id, int pos, int length );
    // Reads from m_styleStack, writes the paragraph properties to layoutElement
    void writeLayout( TQDomDocument& doc, TQDomElement& layoutElement );
    enum NewFrameBehavior { Reconnect=0, NoFollowup=1, Copy=2 };
    TQDomElement createInitialFrame( TQDomElement& parentFramesetElem, double left, double right, double top, double bottom, bool autoExtend, NewFrameBehavior nfb );
    void createStyles( TQDomDocument &doc );
    void createDocumentInfo( TQDomDocument &docinfo );
    void createDocumentContent( TQDomDocument &doccontent, TQDomElement& mainFramesetElement );
    void parseBodyOrSimilar( TQDomDocument &doc, const TQDomElement& parent, TQDomElement& currentFramesetElement );
    KoFilter::ConversionStatus loadAndParse(const TQString& filename, TQDomDocument& doc);
    KoFilter::ConversionStatus openFile();
    bool createStyleMap( const TQDomDocument & styles, TQDomDocument& doc );
    void insertStyles( const TQDomElement& element, TQDomDocument& doc );
    void importDateTimeStyle( const TQDomElement& parent );
    void fillStyleStack( const TQDomElement& object, const char* nsURI, const TQString& attrName );
    void addStyles( const TQDomElement* style );
    void importFootnotesConfiguration( TQDomDocument& doc, const TQDomElement& elem, bool endnote );
    void importFootnote( TQDomDocument& doc, const TQDomElement& object, TQDomElement& formats, uint pos, const TQString& tagName );
    TQString appendPicture( TQDomDocument& doc, const TQDomElement& object );
    TQString appendTextBox( TQDomDocument& doc, const TQDomElement& object );
    void appendTOC( TQDomDocument& doc, const TQDomElement& toc );
    void importFrame( TQDomElement& frameElementOut, const TQDomElement& object, bool isText );
    void importCommonFrameProperties( TQDomElement& frameElementOut );
    void importHeaderFooter( TQDomDocument& doc, const TQDomElement& headerFooter, bool isHeader, TQDomElement& style );
    void anchorFrameset( TQDomDocument& doc, TQDomElement& formats, uint pos, const TQString& frameName );
    void appendField(TQDomDocument& doc, TQDomElement& outputFormats, TQDomElement& object, uint pos);
    void appendKWordVariable(TQDomDocument& doc, TQDomElement& formats, const TQDomElement& object, uint pos,
        const TQString& key, int type, TQDomElement& child);
    void appendBookmark( TQDomDocument& doc, int paragId, int pos, const TQString& name );
    void appendBookmark( TQDomDocument& doc, int paragId, int pos, int endParagId, int endPos, const TQString& name );
    void parseTable( TQDomDocument &doc, const TQDomElement& parent, TQDomElement& currentFramesetElement );
    void parseInsideOfTable( TQDomDocument &doc, const TQDomElement& parent, TQDomElement& currentFramesetElement,
        const TQString& tableName, const TQMemArray<double> & columnLefts, uint& row, uint& column );
    static TQString kWordStyleName(  const TQString& ooStyleName );

    TQDomDocument    m_content;
    TQDomDocument    m_meta;
    TQDomDocument    m_settings;
    TQDomDocument    m_stylesDoc;

    TQDict<TQDomElement>   m_styles;
    TQDict<TQDomElement>   m_masterPages;
    TQDict<TQDomElement>   m_listStyles;

    KoStyleStack m_styleStack;
    TQDomElement m_defaultStyle;
    ListStyleStack m_listStyleStack;
    TQDomElement m_outlineStyle;
    bool m_insideOrderedList;
    bool m_nextItemIsListItem; // only the first elem inside list-item is numbered
    bool m_hasTOC;
    bool m_hasHeader;
    bool m_hasFooter;
    int m_restartNumbering;
    TQString m_currentListStyleName;
    TQString m_currentMasterPage;
    TQDomElement m_currentFrameset; // set by parseBodyOrSimilar

    struct BookmarkStart {
        BookmarkStart() {} // for stupid TQValueList
        BookmarkStart( const TQString&s, int par, int ind )
            : frameSetName( s ), paragId( par ), pos( ind ) {}
        TQString frameSetName;
        int paragId;
        int pos;
    };
    typedef TQMap<TQString, BookmarkStart> BookmarkStartsMap;
    BookmarkStartsMap m_bookmarkStarts;

    typedef TQMap<TQString, TQString> DataFormatsMap;
    DataFormatsMap m_dateTimeFormats; // maybe generalize to include number formats.

    uint m_pictureNumber; // Number of the picture (increment *before* use)
    KZip* m_zip; // Input KZip file
};

#endif

