/* This file is part of the KDE project
   Copyright (C) 2002 Norbert Andres <nandres@web.de>
   Copyright (C) 2004 Montel Laurent <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef OpenCalc_IMPORT_H__
#define OpenCalc_IMPORT_H__

#include <KoFilter.h>
#include "kspread_format.h"

#include <tqdict.h>
#include <tqdom.h>

class KoStyleStack;
class KoStore;

namespace KSpread
{
class Cell;
class Conditional;
class Doc;
class Sheet;
class Validity;
}

class OpenCalcImport : public KoFilter
{
  Q_OBJECT
  TQ_OBJECT
 public:
  OpenCalcImport( KoFilter * parent, const char * name, const TQStringList & );
  virtual ~OpenCalcImport();

  virtual KoFilter::ConversionStatus convert( TQCString const & from, TQCString const & to );


 private:

  class OpenCalcPoint
  {
   public:
    OpenCalcPoint( TQString const & str );

    TQString table;
    TQString translation;
    TQPoint  topLeft;
    TQPoint  botRight;
    bool    isRange;
  };

  enum bPos { Left, Top, Right, Bottom, Fall, GoUp, Border };

  KSpread::Doc *    m_doc;
  KSpread::Format * m_defaultLayout;

  TQDomDocument    m_content;
  TQDomDocument    m_meta;
  TQDomDocument    m_settings;

  TQDict<TQDomElement>   m_styles;
  TQDict<KSpread::Format> m_defaultStyles;
  TQDict<TQString>       m_formats;
  TQMap<TQString,TQDomElement> m_validationList;

  TQStringList          m_namedAreas;

  int  readMetaData();
  bool parseBody( int numOfTables );
  void insertStyles( TQDomElement const & element );
  bool createStyleMap( TQDomDocument const & styles );
  bool readRowFormat( TQDomElement & rowNode, TQDomElement * rowStyle,
                      KSpread::Sheet * table, int & row, int & number, bool last );
  bool readColLayouts( TQDomElement & content, KSpread::Sheet * table );
  bool readRowsAndCells( TQDomElement & content, KSpread::Sheet * table );
  bool readCells( TQDomElement & rowNode, KSpread::Sheet  * table, int row, int & columns );
  void convertFormula( TQString & text, TQString const & f ) const;
  void loadFontStyle( KSpread::Format * layout, TQDomElement const * font ) const;
  void readInStyle( KSpread::Format * layout, TQDomElement const & style );
  void loadStyleProperties( KSpread::Format * layout, TQDomElement const & property ) const;
  void loadBorder( KSpread::Format * layout, TQString const & borderDef, bPos pos ) const;
  void loadTableMasterStyle( KSpread::Sheet * table, TQString const & stylename );
  TQString * loadFormat( TQDomElement * element,
                        KSpread::FormatType & formatType,
                        TQString name );
  void checkForNamedAreas( TQString & formula ) const;
  void loadOasisCellValidation( const TQDomElement&body );
  void loadOasisValidation( KSpread::Validity* val, const TQString& validationName );
  void loadOasisValidationCondition( KSpread::Validity* val,TQString &valExpression );
  void loadOasisAreaName( const TQDomElement&body );
  void loadOasisMasterLayoutPage( KSpread::Sheet * table,KoStyleStack &styleStack );
  void loadOasisValidationValue( KSpread::Validity* val, const TQStringList &listVal );
    TQString translatePar( TQString & par ) const;
    void loadCondition( KSpread::Cell*cell,const TQDomElement &property );
    void loadOasisCondition(KSpread::Cell*cell,const TQDomElement &property );
    void loadOasisConditionValue( const TQString &styleCondition, KSpread::Conditional &newCondition );
    void loadOasisCondition( TQString &valExpression, KSpread::Conditional &newCondition );
    void loadOasisValidationValue( const TQStringList &listVal, KSpread::Conditional &newCondition );
    KoFilter::ConversionStatus loadAndParse( TQDomDocument& doc, const TQString& fileName,KoStore *m_store );

  KoFilter::ConversionStatus openFile();
};

#endif // OpenCalc_IMPORT_H__

