/* This file is part of the KDE project
   Copyright (C) 1998, 1999, 2000 Torben Weis <weis@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "example_part.h"
#include "example_factory.h"
#include "example_view.h"

#include <tqpainter.h>

ExamplePart::ExamplePart( TQWidget *parentWidget, const char *widgetName, TQObject* parent, const char* name, bool singleViewMode )
    : KoDocument( parentWidget, widgetName, parent, name, singleViewMode )
{
    setInstance( ExampleFactory::global(), false );
}

bool ExamplePart::initDoc(InitDocFlags flags, TQWidget* parentWidget)
{
    // If nothing is loaded, do initialize here
    // Most KOffice applications use the template dialog here, with code like:
/*
    KoTemplateChooseDia::DialogType dlgtype;
    if (initDocFlags() != KoDocument::InitDocFileNew )
        dlgtype = KoTemplateChooseDia::Everything;
    else
        dlgtype = KoTemplateChooseDia::OnlyTemplates;

    KoTemplateChooseDia::ReturnType ret = KoTemplateChooseDia::choose(
     .... )
*/
    return TRUE;
}

KoView* ExamplePart::createViewInstance( TQWidget* parent, const char* name )
{
    return new ExampleView( this, parent, name );
}

bool ExamplePart::loadXML( TQIODevice *, const TQDomDocument & )
{
    // TODO load the document from the TQDomDocument
    return true;
}

TQDomDocument ExamplePart::saveXML()
{
    // TODO save the document into a TQDomDocument
    return TQDomDocument();
}

bool ExamplePart::loadOasis( const TQDomDocument & doc, KoOasisStyles& oasisStyles,
		const TQDomDocument & settings, KoStore* store )
{
    // TODO load the document from the TQDomDocument
    return true;
}

bool ExamplePart::saveOasis( KoStore* store, KoXmlWriter* manifestWriter )
{
    // TODO save the document to the KoStore;
    return true;
}

void ExamplePart::paintContent( TQPainter& painter, const TQRect& rect, bool /*transparent*/,
                                double /*zoomX*/, double /*zoomY*/ )
{
    // ####### handle transparency

    // Need to draw only the document rectangle described in the parameter rect.
    int left = rect.left() / 20;
    int right = rect.right() / 20 + 1;
    int top = rect.top() / 20;
    int bottom = rect.bottom() / 20 + 1;

    for( int x = left; x < right; ++x )
        painter.drawLine( x * 20, top * 20, x * 20, bottom * 20 );
    for( int y = left; y < right; ++y )
        painter.drawLine( left * 20, y * 20, right * 20, y * 20 );
}

#include "example_part.moc"
