/*
 *  Copyright (c) 2002, 2003 Patrick Julien <freak@codepimps.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <tqwidget.h>
#include <tqstring.h>
#include <kaction.h>
#include <tqlabel.h>

#include <klocale.h>
#include <kdebug.h>

#include "kis_tool.h"
#include "kis_tool.moc"


class KisTool::KisToolPrivate 
{
public:
    TQString uiname;
    TQLabel * optionWidget;
};

KisTool::KisTool(const TQString & name)
{
    m_action = 0;
    m_ownAction = false;
    d = new KisToolPrivate();
    d->uiname = name;
    d->optionWidget = 0;
}

KisTool::~KisTool()
{
    if (m_ownAction) {
        delete m_action;
        m_action = 0;
    }
    delete d;
}

TQWidget* KisTool::createOptionWidget(TQWidget* parent)
{
    
    d->optionWidget = new TQLabel(i18n("No options for %1.").arg(d->uiname), parent);
    d->optionWidget->setCaption(d->uiname);
    d->optionWidget->setAlignment(TQt::AlignCenter);
    return d->optionWidget;
}

TQWidget* KisTool::optionWidget()
{
    return d->optionWidget;
}

