/*
 *  kis_tool_star.h - part of Chalk
 *
 *  Copyright (c) 2004 Michael Thaler <michael Thaler@physik.tu-muenchen.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef KIS_TOOL_STAR_H_
#define KIS_TOOL_STAR_H_

#include "kis_tool_shape.h"

class KisCanvas;
class KisDoc;
class KisPainter;
class KisView;
class KisRect;
class WdgToolStar;

class KisToolStar : public KisToolShape {

    typedef KisToolShape super;
    Q_OBJECT
  TQ_OBJECT

public:
    KisToolStar();
    virtual ~KisToolStar();

        //
        // KisCanvasObserver interface
        //

        virtual void update (KisCanvasSubject *subject);

        virtual TQWidget* createOptionWidget(TQWidget* parent);

        //
        // KisToolPaint interface
        //

    virtual void setup(KActionCollection *collection);
    virtual enumToolType toolType() { return TOOL_SHAPE; }
    virtual TQ_UINT32 priority() { return 6; }	
    virtual void buttonPress(KisButtonPressEvent *event);
    virtual void move(KisMoveEvent *event);
    virtual void buttonRelease(KisButtonReleaseEvent *event);

protected:
    virtual void draw(const KisPoint& start, const KisPoint& stop);
    //virtual void draw(KisPainter *gc, const TQRect& rc);

protected:
    int m_lineThickness;

    KisPoint m_dragStart;
    KisPoint m_dragEnd;
    TQRect m_final_lines;

    bool m_dragging;
    KisImageSP m_currentImage;
private:
        vKisPoint starCoordinates(int N, double mx, double my, double x, double y);
        TQ_INT32 m_innerOuterRatio;
        TQ_INT32 m_vertices;
    WdgToolStar* m_optWidget;
};


#include "kis_tool_factory.h"

class KisToolStarFactory : public KisToolFactory {
    typedef KisToolFactory super;
public:
    KisToolStarFactory() : super() {};
    virtual ~KisToolStarFactory(){};

    virtual KisTool * createTool(KActionCollection * ac) {
        KisTool * t =  new KisToolStar();
        Q_CHECK_PTR(t);
        t->setup(ac);
        return t;
    }
    virtual KisID id() { return KisID("starshape", i18n("Star Tool")); }
};


#endif //__KIS_TOOL_STAR_H__
