/*
 * This file is part of Chalk
 *
 * Copyright (c) 2006 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "kis_wdg_fastcolortransfer.h"

#include <tqlayout.h>

#include <kurlrequester.h>

#include "wdgfastcolortransfer.h"

KisWdgFastColorTransfer::KisWdgFastColorTransfer(KisFilter* nfilter, TQWidget * parent, const char * name) : KisFilterConfigWidget ( parent, name )
{
    TQGridLayout *widgetLayout = new TQGridLayout(this, 1, 1);
    m_widget = new WdgFastColorTransfer(this);
    widgetLayout -> addWidget(m_widget,0,0);
    connect(m_widget->fileNameURLRequester, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SIGNAL(sigPleaseUpdatePreview()));
}


KisWdgFastColorTransfer::~KisWdgFastColorTransfer()
{
}

void KisWdgFastColorTransfer::setConfiguration(KisFilterConfiguration* config)
{
    TQVariant value;
    if (config->getProperty("filename", value))
    {
        widget()->fileNameURLRequester->setURL( value.toString() );
    }

}
