/*
 * This file is part of Chalk
 *
 * Copyright (c) 1999 Matthias Elter (me@kde.org)
 * Copyright (c) 2001-2002 Igor Jansen (rm@kde.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <tqpushbutton.h>
#include <tqapplication.h>
#include <tqclipboard.h>
#include <tqcolor.h>
#include <tqdrawutil.h>
#include <tqhbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqspinbox.h>
#include <tqstyle.h>
#include <tqtooltip.h>

#include <klocale.h>
#include <knuminput.h>
#include <koFrameButton.h>

#include <kis_meta_registry.h>
#include <kis_factory.h>
#include <kis_canvas_subject.h>
#include <kis_colorspace_factory_registry.h>
#include <kis_color.h>
#include <kis_color_cup.h>

#include "kis_wet_colorspace.h"
#include "kis_wet_palette_widget.h"

KisWetPaletteWidget::KisWetPaletteWidget(TQWidget *parent, const char *name) : super(parent, name)
{
    m_subject = 0;

    TQVBoxLayout * vl = new TQVBoxLayout(this, 0, -1, "main layout");

    TQGridLayout * l = new TQGridLayout(vl, 2, 8, 2, "color wells grid");

    KisColorCup * b;
    int WIDTH = 24;
    int HEIGHT = 24;

    b = new KisColorCup(this);
    b->setColor( TQColor(240, 32, 160) );
    l->addWidget(b, 0, 0);
    TQToolTip::add(b, i18n("Quinacridone Rose"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor(TQColor(159, 88, 43));
    l->addWidget(b, 0, 1);
    TQToolTip::add(b,i18n("Indian Red"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor( TQColor(254, 220, 64) );
    l->addWidget(b, 0, 2);
    TQToolTip::add(b,i18n("Cadmium Yellow"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor(TQColor(36, 180, 32));
    l->addWidget(b, 0, 3);
    TQToolTip::add(b,i18n("Hookers Green"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor(TQColor(16, 185, 215));
    l->addWidget(b, 0, 4);
    TQToolTip::add(b,i18n("Cerulean Blue"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor(TQColor(96, 32, 8));
    l->addWidget(b, 0, 5);
    TQToolTip::add(b,i18n("Burnt Umber"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor(TQColor(254, 96, 8));
    l->addWidget(b, 0, 6);
    TQToolTip::add(b,i18n("Cadmium Red"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor(TQColor(255, 136, 8));
    l->addWidget(b, 0, 7);
    TQToolTip::add(b,i18n("Brilliant Orange"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor(TQColor(240, 199, 8));
    l->addWidget(b, 1, 0);
    TQToolTip::add(b,i18n("Hansa Yellow"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor(TQColor(96, 170, 130));
    l->addWidget(b, 1, 1);
    TQToolTip::add(b,i18n("Phthalo Green"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor(TQColor(48, 32, 170));
    l->addWidget(b, 1, 2);
    TQToolTip::add(b,i18n("French Ultramarine"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor(TQColor(118, 16, 135));
    l->addWidget(b, 1, 3);
    TQToolTip::add(b,i18n("Interference Lilac"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor(TQColor(254, 254, 254));
    l->addWidget(b, 1, 4);
    TQToolTip::add(b,i18n("Titanium White"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor(TQColor(64, 64, 74));
    l->addWidget(b, 1, 5);
    TQToolTip::add(b,i18n("Ivory Black"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    b = new KisColorCup(this);
    b->setColor(TQColor(255, 255, 255));
    l->addWidget(b, 1, 6);
    TQToolTip::add(b,i18n("Pure Water"));
    b->setFixedSize(WIDTH, HEIGHT);
    connect(b, TQT_SIGNAL(changed(const TQColor &)), TQT_SLOT(slotFGColorSelected(const TQColor &)));

    TQGridLayout * g2 = new TQGridLayout(vl, 2, 2);
    
    TQLabel * label = new TQLabel(i18n("Paint strength:"), this);
    g2->addWidget(label, 0, 0);
    m_strength = new KDoubleNumInput(0.0, 2.0, 1.0, 0.1, 1, this);
    m_strength->setRange(0.0, 2.0, 0.1, true);
    connect(m_strength, TQT_SIGNAL(valueChanged(double)), this,  TQT_SLOT(slotStrengthChanged(double)));
    g2->addWidget(m_strength, 0, 1);

    label = new TQLabel(i18n("Wetness:"), this);
    g2->addWidget(label, 1, 0);
    m_wetness = new KIntNumInput(16, this);
    connect(m_wetness, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(slotWetnessChanged(int)));
    m_wetness->setRange(0, 16, true);
    g2->addWidget(m_wetness, 1, 1);

    g2->addItem(new TQSpacerItem(1, 1, TQSizePolicy::Expanding, TQSizePolicy::Minimum));

}

void KisWetPaletteWidget::update(KisCanvasSubject *subject)
{
    m_subject = subject;

}

void KisWetPaletteWidget::slotFGColorSelected(const TQColor& c)
{
    KisWetColorSpace* cs = dynamic_cast<KisWetColorSpace*>(KisMetaRegistry::instance()->csRegistry()->getColorSpace(KisID("WET", ""), ""));
     Q_ASSERT(cs);

    WetPack pack;
    TQ_UINT8* data = reinterpret_cast< TQ_UINT8*>(&pack);
    cs->fromTQColor(c, data);
    pack.paint.w = 15 * m_wetness->value();
    // upscale from double to uint16:
    pack.paint.h = static_cast< TQ_UINT16>(m_strength->value() * (double)(0xffff/2));
    KisColor color(data, cs);

    if(m_subject)
        m_subject->setFGColor(color);
}

void KisWetPaletteWidget::slotWetnessChanged(int n)
{
    if (!m_subject)
        return;

    KisWetColorSpace* cs = dynamic_cast<KisWetColorSpace*>(KisMetaRegistry::instance()->csRegistry()->getColorSpace(KisID("WET", ""), ""));
     Q_ASSERT(cs);

    KisColor color = m_subject->fgColor();
    color.convertTo(cs);
    WetPack pack = *(reinterpret_cast<WetPack*>(color.data()));
    pack.paint.w = 15 * n;

    color.setColor(reinterpret_cast<  TQ_UINT8*>(&pack), cs);
    m_subject->setFGColor(color);
}

void KisWetPaletteWidget::slotStrengthChanged(double n)
{
    if (!m_subject)
        return;

    KisWetColorSpace* cs = dynamic_cast<KisWetColorSpace*>(
            KisMetaRegistry::instance()->csRegistry()->getColorSpace(KisID("WET", ""), ""));
     Q_ASSERT(cs);

    KisColor color = m_subject->fgColor();
    color.convertTo(cs);
    WetPack pack = *(reinterpret_cast<WetPack*>(color.data()));
    pack.paint.h = static_cast< TQ_UINT16>(n * (double)(0xffff/2)); // upscale from double to uint16

    color.setColor(reinterpret_cast<  TQ_UINT8*>(&pack), cs);
    m_subject->setFGColor(color);
}


#include "kis_wet_palette_widget.moc"
