/***************************************************************************
                          knutclient.h  -  description
                             -------------------
    begin                : t srp 21 19:12:20 CEST 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTCLIENT_H
#define KNUTCLIENT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "knutmainwindow.h"
#include "knutvardata.h"
#include "knutupsdata.h"
#include "knutnet.h"
#include "knutdock.h"
#include "knutprefdlg.h"
#include "knutmessagemanager.h"

#include <kapplication.h>


#include <tqwidget.h>
#include <tqtimer.h>
#include <tqstringlist.h>
#include <tqmutex.h>

  const int countNextConnDelay = 10;
  const int nextConnDelay[] = {
  5, 5, 20, 30, 60, 60, 120, 300, 600, 900 };


class KNutClient : public TQObject, public KSessionManaged {
  Q_OBJECT
  TQ_OBJECT
  public:
    KNutClient(bool noDock = false, TQObject* parent=0,const char* name=0);
    ~KNutClient();

  private slots:
    void slotTimeout (void);

    void slotReconnectTimeout (void);

    void slotSetNewUPS (TQString name);

    void slotPreferenceUps(void);

    void slotSetConfig (unsigned int changeSetting);

    void slotPrintUPSVars(void);
    void slotInstComms(void);
    void slotRWVars(void);
    void slotChangeRWVars( TQString );

    void slotSaveConf (void);


    void slotExitApplication(void);


/**
 * 
 * Calls function for repainting of icon in dock.
 * Vola funkci pro prekresleni icony v doku.
 * 
 * @since  0.1
 **/
    void slotTryFirstConnection (int maxCount);



/**
 * This function is called when program repeats other connection;
 * Calls function for repainting of icon in dock.
 * Tata funkce je volana, kdyz program opakuje pokus o pripojeni.
 * Vola funkci pro prekresleni icony v doku.
 * 
 * @since  0.1
 **/
  void slotTryReepatFirstConnection (int number );


/**
 * Nastavi hodnoty po prvem pripojeni na UPS, zavola prekresleni docku a  nastartuje timer
 * Sets values after the first conection to UPS ,calls to repaint of dock and starts timer
 * 
 * @since  0.2
 **/
    void slotFirstConnection (void);



/**
 * Zpracuje chybu spojeni
 * Executes error of connection
 * 
 * @since  0.1
 **/
    void slotErrorConnection (int error);


/**
 * Zpracuje ukonceni spojeni, pokud spojeni bylo ukonceno druhou stranou.
 * Executes end of connection, when connection was closed by the second side.
 * 
 * @since  0.1
 **/
    void slotConnectionClosed(void);


/**
 *
 *
 * @since  0.1
 **/
    void slotRefreshConnection(void);


    void closeMainWindow (void);
    void exitMainWindow (void);
    void slotActiveMainWindow (void);

    virtual bool commitData (TQSessionManager&);
    virtual bool saveState (TQSessionManager&);

  private:

/**
 * Prepares and show main window.
 * Pripravi a zobrazi hlavni okno.
 *
 * @since  0.1
 **/
    void makeMainWindow (void);

/**
 * Sets all variables to initial values.
 * Nastavi vsechny vsechny promenne na pocatecni hodnoty.
 *
 * @since  0.1
 **/
    void initVars (void);

    void loadConfiguration ( void );
    void saveConfiguration ( bool all = true );

    void upsActivate (void);
    void upsDeactivate (void);

    void setActiveUpsVars (bool mWindow = true);
    void setActiveXFerVars (bool activate);

    void getUpsData (void);

    void setActiveUpsInfo (TQString name);

    void addEventString (const TQString text, const TQString UPSAddress = TQString());

    void showStatusEvent(void);




/********* PRIVATE VARS****************/
    // hlavni informace o upsce
    // main informacion about UPS
    KNutVarData::upsInfoDef m_mainUpsInfo;

    // v teto strukture jsou ulozeny promene ktere nastavuji konfiguraci
    // in this structure are saveing values, which setting configuration
    KNutVarData::SettingDataDef settingData;

    KNutDock* m_myDock;

    KNutMainWindow* mainWindow;

    KNutUpsData* upsRecords;
    KNutVarData* analogRecords;

    TQTimer* m_upsTimer;
    TQTimer* m_reconnectTimer;

    TQStringList* m_listKNutEvent;

    bool m_panelsAreZeroing; //   indikuje zda je panel nulovany // use if analog panels is setting to zero
    //  kod posledni chyby spojeni zjistene v timeoutu
    //  nebere ohled zda byla chyba pri inicializaci
    int m_lastError;

    KNutMessageManager* m_myMessMan;

    // mutex for reconnect, only one reconnect at a time
    TQMutex m_reconnectMutex;
    TQMutex m_upsDeactivateMutex;

  };
#endif
