/***************************************************************************
                          tabbox.h  -  description
                             -------------------
    begin                : Fri Sep 13 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TABBOX_H
#define TABBOX_H

#include <tqvbox.h>
#include "accel.h"

class TQTabWidget;
class resource;

/**
  *@author Troy Corbin Jr.
  */

class TabBox : public TQVBox
{
	Q_OBJECT
  TQ_OBJECT
	public:
								TabBox( resource *rsrc=0 );
		virtual			~TabBox();
		void				keyPressEvent( TQKeyEvent* );
		void				addTab( TQWidget *child, const TQString &caption );
		void				removeTab( TQWidget *child, bool deleteChild=FALSE );
		bool				isChild( TQWidget *child );
		void				showTab( TQWidget *child );
		void				changeCaption( TQWidget *child, const TQString &caption );
		int					count( void );

	signals:
		void				newTabBox( TabBox* );
		void				saveTabGeometry( const TQString&, const TQSize& );
		void				focus( const TQChar& );

	protected slots:
		void				changeMyCaption( TQWidget *child );

								/**
									This removes and deletes a Tab if it's a child of this widget.
									Never call this directly; Only with a Signal!
								*/
		void				destroyChild( void );

	private:
		TQTabWidget	*myTabs;
		Accel				*myAccel;
		resource		*myResource;
};

#endif
