
/***************************************************************************
 *                                                                         *
 *   KNetLoad is copyright (c) 1999-2000, Markus Gustavsson                *
 *                         (c) 2002, Ben Burton                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __KNETLOAD_H
#define __KNETLOAD_H

#include "statpopup.h"

#include <tqptrlist.h>

class KAction;
class KNetProc;
class KPopupMenu;

/**
 * The specific pop-up window used by KNetLoad.
 */
class KNetLoad : public StatPopup {
    Q_OBJECT
  TQ_OBJECT

public:
    /**
     * Constructor and destructor.
     */
    KNetLoad(TQWidget *parent = 0, const char *name = 0);
    ~KNetLoad();

public slots:
    /**
     * Slots for menu items.
     */
    void setDevice(const TQString& newDevice);
    void setDevice(int deviceIndex);
    void setScaleIn(int scale);
    void setScaleOut(int scale);

protected:
    /**
     * Overrides from StatPopup.
     */
    virtual TQString dockName(int which) const;
    virtual TQColor defaultDockColor(int which) const;
    virtual void setupCustomActions();
    virtual void insertCustomItems(KPopupMenu* menu);
    virtual void takeReadingInternal();

private:
    /**
     * Updating menus to reflect the current configuration.
     */
    void updateDeviceMenu(KPopupMenu* menu);
    void updateDeviceMenus();
    void updateScaleInMenu(KPopupMenu* menu);
    void updateScaleInMenus();
    void updateScaleOutMenu(KPopupMenu* menu);
    void updateScaleOutMenus();

private:
    /**
     * Reading raw network throughput information.
     */
    KNetProc* proc;
        /**< Used to obtain the raw information. */
    float bitRateIn, bitRateOut;
        /**< Temporary variables used in calculations. */

    /**
     * Monitor settings.
     */
    int scaleIn, scaleOut;
        /**< The scale for each diagram in bits per second.
             If scaleOut == 0, scaleIn should be used for both directions. */

    /**
     * Lists of menus that must be kept up-to-date.
     */
    TQPtrList<KPopupMenu> deviceMenus;
    TQPtrList<KPopupMenu> scaleInMenus;
    TQPtrList<KPopupMenu> scaleOutMenus;
    
    TQStringList stockDevice;
    TQStringList stockDeviceIconOn;
    TQStringList stockDeviceIconOff;
};

#endif
