/***************************************************************************
                             ofxpartner.h
                             ----------
    begin                : Fri Jan 23 2009
    copyright            : (C) 2009 by Thomas Baumgart
    email                : Thomas Baumgart <ipwizard@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OFXPARTNER_H
#define OFXPARTNER_H

// ----------------------------------------------------------------------------
// QT Includes


#include <tqobject.h>
#include <tqhttp.h>

// ----------------------------------------------------------------------------
// KDE Includes

#include <kurl.h>
namespace KIO
{
  class Job;
  class TransferJob;
}

// ----------------------------------------------------------------------------
// Project Includes

#include <libofx/libofx.h>

namespace OfxPartner
{
  /**
    * setup the directory where the files will be stored.
    * @a dir must end with a '/' and must exist. Call this
    * before any other of the functions of OfxPartner. The
    * default will be to store the files in the current
    * directory.
    */
  void setDirectory(const TQString& dir);

  void ValidateIndexCache(void);
  OfxFiServiceInfo ServiceInfo(const TQString& fipid);
  TQValueList<TQString> BankNames(void);
  TQValueList<TQString> FipidForBank(const TQString& bank);

}

class OfxHttpRequest : public TQObject
{
  Q_OBJECT
  TQ_OBJECT
public:
  OfxHttpRequest(const TQString& method, const KURL &url, const TQByteArray &postData, const TQMap<TQString, TQString>& metaData, const KURL& dst, bool showProgressInfo=true);
  virtual ~OfxHttpRequest() {}

  TQHttp::Error error(void) const { return m_error; }

protected slots:
  void slotOfxFinished(int, bool);

private:
  TQHttp*	      m_job;
  KURL          m_dst;
  TQHttp::Error  m_error;

};

class OfxHttpsRequest : public TQObject
{
Q_OBJECT
  TQ_OBJECT
public:
  OfxHttpsRequest(const TQString& method, const KURL &url, const TQByteArray &postData, const TQMap<TQString, TQString>& metaData, const KURL& dst, bool showProgressInfo=true);
  virtual ~OfxHttpsRequest();

  TQHttp::Error error(void) const { return m_error; }

protected slots:
  void slotOfxFinished(KIO::Job*);
  void slotOfxData(KIO::Job*,const TQByteArray&);
  void slotOfxConnected(KIO::Job*);

private:
  class Private;
  Private*          d;
  KURL              m_dst;
  TQFile             m_file;
  TQHttp::Error      m_error;
  KIO::TransferJob* m_job;
};
#endif // OFXPARTNER_H
