/***************************************************************************
                          krecentfileitem.cpp  -  description
                             -------------------
    begin                : Wed Jul 30 2003
    copyright            : (C) 2000-2003 by Michael Edwardes
    email                : mte@users.sourceforge.net
                           Javier Campos Morales <javi_c@users.sourceforge.net>
                           Felix Rodriguez <frodriguez@users.sourceforge.net>
                           John C <thetacoturtle@users.sourceforge.net>
                           Thomas Baumgart <ipwizard@users.sourceforge.net>
                           Kevin Tambascio <ktambascio@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// ----------------------------------------------------------------------------
// QT Includes

#include <tqtooltip.h>
#include <tqwidget.h>
#include <tqrect.h>
#include <tqpoint.h>

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes


#include "krecentfileitem.h"

KRecentFileItem::KRecentFileItem(const TQString& url, TQIconView* parent, const TQString& text, const TQPixmap& icon)
  : TQIconViewItem(parent, text, icon),
    m_url(url),
    m_parent(parent)
{
  TQToolTip::add(parent, rect(), url);
  // avoid moving this item around
  setDragEnabled(false);
}

KRecentFileItem::~KRecentFileItem()
{
}

bool KRecentFileItem::move( int x, int y )
{
  TQRect r = rect();
  TQToolTip::remove(m_parent, rect());
  r.moveTopLeft(TQPoint(x,y));
  TQToolTip::add(m_parent, r, m_url);
  return TQIconViewItem::move(x,y);
}

