/***************************************************************************
                          mymoneyqifprofile.h  -  description
                             -------------------
    begin                : Tue Dec 24 2002
    copyright            : (C) 2002 by Thomas Baumgart
    email                : thb@net-bembel.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYMONEYQIFPROFILE_H
#define MYMONEYQIFPROFILE_H

// ----------------------------------------------------------------------------
// QT Includes

#include <tqobject.h>
#include <tqstring.h>
class TQDate;

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes

class MyMoneyMoney;

/**
  * @author Thomas Baumgart
  */

class MyMoneyQifProfile : public TQObject
{
  Q_OBJECT
  TQ_OBJECT

public:
  MyMoneyQifProfile();
  MyMoneyQifProfile(const TQString& name);
  ~MyMoneyQifProfile();

  const TQString& profileName(void) const { return m_profileName; }
  void setProfileName(const TQString& name);

  void loadProfile(const TQString& name);
  void saveProfile(void);

  const TQDate date(const TQString& datein) const;
  TQString date(const TQDate& datein) const;

  MyMoneyMoney value(const TQChar& def, const TQString& valuein) const;
  TQString value(const TQChar& def, const MyMoneyMoney& valuein) const;

  const TQString& outputDateFormat(void) const { return m_dateFormat; }
  TQString inputDateFormat(void) const;
  const TQString& apostropheFormat(void) const { return m_apostropheFormat; }
  TQChar amountDecimal(const TQChar& def) const;
  TQChar amountThousands(const TQChar& def) const;
  const TQString& profileDescription(void) const { return m_profileDescription; }
  const TQString& profileType(void) const { return m_profileType; }
  const TQString& openingBalanceText(void) const { return m_openingBalanceText; }
  TQString accountDelimiter(void) const;
  const TQString& voidMark(void) const { return m_voidMark; }
  const TQString& filterScriptImport(void) const { return m_filterScriptImport; }
  const TQString& filterScriptExport(void) const { return m_filterScriptExport; }
  const TQString& filterFileType(void) const { return m_filterFileType; }
  bool attemptMatchDuplicates(void) const { return m_attemptMatchDuplicates; }

  /**
   * This method scans all strings contained in @a lines and tries to figure
   * out the settings for m_decimal, m_thousands and m_dateFormat
   */
  void autoDetect(const TQStringList& lines);

  /**
   * This method returns a list of possible date formats the user
   * can choose from. If autoDetect() has not been run, the @a list
   * contains all possible date formats, in the other case, the @a list
   * is adjusted to those that will match the data scanned.
   */
  void possibleDateFormats(TQStringList& list) const;

  /**
    * This method presets the member variables with the default values.
    */
  void clear(void);

  /**
    * This method is used to determine, if a profile has been changed or not
    */
  bool isDirty(void) const { return m_isDirty; };

public slots:
  void setProfileDescription(const TQString& desc);
  void setProfileType(const TQString& type);
  void setOutputDateFormat(const TQString& dateFormat);
  void setInputDateFormat(const TQString& dateFormat);
  void setApostropheFormat(const TQString& apostropheFormat);
  void setAmountDecimal(const TQChar& def, const TQChar& chr);
  void setAmountThousands(const TQChar& def, const TQChar& chr);
  void setAccountDelimiter(const TQString& delim);
  void setOpeningBalanceText(const TQString& text);
  void setVoidMark(const TQString& txt);
  void setFilterScriptImport(const TQString& txt);
  void setFilterScriptExport(const TQString& txt);
  void setFilterFileType(const TQString& txt);
  void setAttemptMatchDuplicates(bool);

private:
  TQString twoDigitYear(const TQChar delim, int yr) const;
  void scanNumeric(const TQString& txt, TQChar& decimal, TQChar& thousands) const;
  void scanDate(const TQString& txt) const;

private:
  /// \internal d-pointer class.
  class Private;
  /// \internal d-pointer instance.
  Private* const d;
  bool      m_isDirty;
  TQString   m_profileName;
  TQString   m_profileDescription;
  TQString   m_dateFormat;
  TQString   m_apostropheFormat;
  TQString   m_valueMode;
  TQString   m_profileType;
  TQString   m_openingBalanceText;
  TQString   m_voidMark;
  TQString   m_accountDelimiter;
  TQString   m_filterScriptImport;
  TQString   m_filterScriptExport;
  TQString   m_filterFileType;  /*< The kind of input files the filter will expect, e.g. "*.qif" */
  TQMap<TQChar, TQChar> m_decimal;
  TQMap<TQChar, TQChar> m_thousands;
  bool      m_attemptMatchDuplicates;
};

#endif
