/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2003-10-21
 * Description : a kipi plugin to slide images.
 *
 * Copyright (C) 2003-2007 Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef LISTIMAGEITEM_H
#define LISTIMAGEITEM_H

// QT includes

#include <tqevent.h>
#include <tqwidget.h>
#include <tqstring.h>

// KDE includes

#include <klistbox.h>
#include <kurl.h>

namespace KIPISlideShowPlugin
{

class ImageItem : public TQListBoxText
{

public:

    ImageItem(TQListBox * parent, TQString const & name, TQString const & comments, TQString const & path,
              TQString const & album)
    : TQListBoxText(parent), _name(name), _comments(comments), _path(path), _album(album)
    {}

    TQString comments()                   { return _comments; }
    TQString name()                       { return _name;     }
    TQString path()                       { return _path;     }
    TQString album()                      { return _album;    }
    void setName(const TQString &newName) { setText(newName); }

private:

    TQString _name;
    TQString _comments;
    TQString _path;
    TQString _album;
};

class ListImageItems : public KListBox 
{
    Q_OBJECT
  TQ_OBJECT

    public:

        ListImageItems(TQWidget *parent=0, const char *name=0);

    signals:

        void addedDropItems(KURL::List filesUrl);

    protected:

        void dragEnterEvent(TQDragEnterEvent *e);
        void dropEvent(TQDropEvent *e);
};

}  // NameSpace KIPISlideShowPlugin

#endif /* LISTIMAGEITEM_H */
