/***************************************************************************
                          cropframe.h  -  description
                             -------------------
    begin                : Mon Sep 30 2002
    copyright            : (C) 2002 by Todd Shoemaker
    email                : jtshoe11@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CROPFRAME_H
#define CROPFRAME_H

// TQt includes.

#include <tqwidget.h>
#include <tqpixmap.h>

// Local includes.

#include "tphoto.h"

namespace KIPIPrintWizardPlugin
{

class CropFrame : public TQWidget
{
  Q_OBJECT
  TQ_OBJECT

  public:
    CropFrame(TQWidget *parent, const char *name);
    ~CropFrame();
    void init(TPhoto *photo, int width, int height, bool autoRotate, bool paint = true);
    void setColor(TQColor);
    TQColor color();

  private:
    TPhoto *m_photo;
    bool m_mouseDown;
    TQPixmap *m_pixmap;
    int m_pixmapX;
    int m_pixmapY;

    TQColor m_color;

    TQRect m_cropRegion;


    TQRect _screenToPhotoRect(TQRect r);
    TQRect _photoToScreenRect(TQRect r);
  
  protected:
    void paintEvent (TQPaintEvent *);
    void mousePressEvent(TQMouseEvent *);
    void mouseReleaseEvent(TQMouseEvent *);
    void mouseMoveEvent(TQMouseEvent *);
    void keyPressEvent(TQKeyEvent *);
};

}  // NameSpace KIPIPrintWizardPlugin

#endif // CROPFRAME_H
