//////////////////////////////////////////////////////////////////////////////
//
//    OPTIONSDIALOG.CPP
//
//    Copyright (C) 2003 Gilles CAULIER <caulier dot gilles at gmail dot com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////

// Include files for TQt

#include <tqvbox.h>
#include <tqlayout.h>
#include <tqwidget.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqgroupbox.h>
#include <tqstring.h>

// Include files for KDE

#include <klocale.h>
#include <klineedit.h>
#include <kiconloader.h>
#include <kfiledialog.h>

// Local includes.

#include "optionsdialog.h"
#include "kimg2mpg.h"

namespace KIPIMPEGEncoderPlugin
{

////////////////////////////////// CONSTRUCTOR //////////////////////////////////////////////

OptionsDialog::OptionsDialog(TQWidget *parent)
                 : KDialogBase( parent, "MPEGEncoderOptionsDialog", true,
                 i18n("MPEG Encoder Plugin Settings"), Ok|Cancel, Ok, false)
{
  Icons = new KIconLoader( TQString( "MenuDlg" ) );

  TQWidget* box = new TQWidget( this );
  setMainWidget(box);
  TQVBoxLayout* vbox = new TQVBoxLayout (box, 10);
  TQHBoxLayout* h1 = new TQHBoxLayout( vbox );
  TQVBoxLayout* v1 = new TQVBoxLayout( h1 );
  h1->addSpacing( 5 );
  TQGridLayout* g1 = new TQGridLayout( v1, 3, 3 );

  // ImageMagick binary programs folder

  TQGroupBox* IMBinFolderGroup = new TQGroupBox( 3, Qt::Horizontal, i18n( "ImageMagick Binary Programs Path" ), box);
  g1->addWidget( IMBinFolderGroup, 1, 1, TQt::AlignLeft);
  IMBinFolderEditFilename = new KLineEdit( IMBinFolderGroup );
  IMBinFolderEditFilename->setMinimumWidth( 300 );
  TQPushButton* IMBinFolderButtonFilename = new TQPushButton( IMBinFolderGroup );
  IMBinFolderButtonFilename->setPixmap( LoadIcon( TQString( "fileopen" ), KIcon::Toolbar ) );
  connect( IMBinFolderButtonFilename, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotIMBinFolderFilenameDialog()));

  // MjpegTools binary programs folder

  TQGroupBox* MJBinFolderGroup = new TQGroupBox( 3, Qt::Horizontal, i18n( "MjpegTools Binary Programs Path" ), box);
  g1->addWidget( MJBinFolderGroup, 2, 1, TQt::AlignLeft);
  MJBinFolderEditFilename = new KLineEdit( MJBinFolderGroup );
  MJBinFolderEditFilename->setMinimumWidth( 300 );
  TQPushButton* MJBinFolderButtonFilename = new TQPushButton( MJBinFolderGroup );
  MJBinFolderButtonFilename->setPixmap( LoadIcon( TQString( "fileopen" ), KIcon::Toolbar ) );
  connect( MJBinFolderButtonFilename, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotMJBinFolderFilenameDialog()));
}


//////////////////////////////////// DESTRUCTOR /////////////////////////////////////////////

OptionsDialog::~OptionsDialog()
{
}


//////////////////////////////////// FONCTIONS //////////////////////////////////////////////

TQPixmap OptionsDialog::LoadIcon( TQString Name, int Group )
{
  return Icons->loadIcon( Name, (KIcon::Group)Group );
}

////////////////////////////////// SLOTS ////////////////////////////////////////////////////


void OptionsDialog::slotIMBinFolderFilenameDialog( void )
{
  TQString temp;

  temp = KFileDialog::getExistingDirectory(IMBinFolderEditFilename->text(),
                                           this,
                                           i18n("Select path to ImageMagick binary programs..."));

  if( temp.isEmpty() )
    return;

  IMBinFolderEditFilename->setText( temp );
}


void OptionsDialog::slotMJBinFolderFilenameDialog( void )
{
  TQString temp;

  temp = KFileDialog::getExistingDirectory(MJBinFolderEditFilename->text(),
                                           this,
                                           i18n("Select path to MjpegTools binary programs..."));

  if( temp.isEmpty() )
    return;

  MJBinFolderEditFilename->setText( temp );
}

}  // NameSpace KIPIMPEGEncoderPlugin

#include "optionsdialog.moc"
