/* ============================================================
 * Copyright 2004 by Tudor Calin <tudor@1xtech.com>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */
#ifndef THUMBVIEW_H
#define THUMBVIEW_H

#include <tqscrollview.h>

class TQPainter;
class TQMouseEvent;
class TQPaintEvent;
class TQDropEvent;
class TQPoint;

namespace KIPIKameraKlientPlugin
{

class ThumbItem;
class ThumbViewPrivate;

class ThumbView : public TQScrollView {

    Q_OBJECT
  TQ_OBJECT

    friend class ThumbItem;
    
public:

    ThumbView(TQWidget* parent=0, const char* name=0,
              WFlags fl=0);
    ~ThumbView();

    ThumbItem* firstItem();
    ThumbItem* lastItem();
    ThumbItem* findItem(const TQPoint& pos);
    ThumbItem* findItem(const TQString& text);

    int count();
    int index(ThumbItem* item);
    
    virtual void clear(bool update=true);
    void rearrangeItems(bool update=true);

    void clearSelection();
    void selectAll();
    void invertSelection();

    void selectItem(ThumbItem* item, bool select);

    virtual void insertItem(ThumbItem *item);
    virtual void takeItem(ThumbItem *item);
    void updateItemContainer(ThumbItem *item);
    TQRect contentsRectToViewport(const TQRect& r);

    void ensureItemVisible(ThumbItem *item);
    ThumbItem *findFirstVisibleItem(const TQRect &r ) const;
    ThumbItem *findLastVisibleItem(const  TQRect &r ) const;

    void sort();
    
protected:

    virtual void contentsMousePressEvent(TQMouseEvent *e);
    virtual void contentsMouseMoveEvent(TQMouseEvent *e);
    virtual void contentsMouseReleaseEvent(TQMouseEvent *e);
    virtual void contentsMouseDoubleClickEvent(TQMouseEvent *e);
    
    virtual void viewportPaintEvent(TQPaintEvent *pe);
    virtual void resizeEvent(TQResizeEvent* e);

    virtual void keyPressEvent(TQKeyEvent *e);
        
    virtual void startDrag();
    virtual void contentsDropEvent(TQDropEvent *e);

private:

    void drawRubber(TQPainter *p);

    void rebuildContainers();
    void appendContainer();
    void deleteContainers();

private:

    ThumbItem* makeRow(ThumbItem *begin, int &y, bool &changed);
    void emitRenamed(ThumbItem *item);

private:


    ThumbViewPrivate *d;
    ThumbItem *renamingItem;

signals:

    void signalSelectionChanged();
    void signalRightButtonClicked(const TQPoint &pos);
    void signalRightButtonClicked(ThumbItem *item, const TQPoint &pos);
    void signalDoubleClicked(ThumbItem *item);
    void signalReturnPressed(ThumbItem *item);
    void signalItemRenamed(ThumbItem *item);

public slots:

    void slotUpdate();
    
};

}  // NameSpace KIPIKameraKlientPlugin

#endif
