/* ============================================================
 * File  : gpeventfilter.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-01-21
 * Description : 
 * 
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef GPEVENTFILTER_H
#define GPEVENTFILTER_H

#include <tqobject.h>

#include "gpfileiteminfo.h"

class TQEvent;
class TQImage;
class TQString;

namespace KIPIKameraKlientPlugin
{

class CameraUI;

class GPEventFilter : public TQObject {
    Q_OBJECT
  TQ_OBJECT
    
public:
    GPEventFilter(TQObject *parent);
    ~GPEventFilter();

protected:
    bool eventFilter(TQObject *obj, TQEvent *e);

private:
    CameraUI *view_;
    
signals:
    void signalCameraError(const TQString&);
    void signalStatusMsg(const TQString&);
    void signalProgressVal(int);
    void signalBusy(bool);
    
};

}  // NameSpace KIPIKameraKlientPlugin

#endif

