/***************************************************************************
 * copyright            : (C) 2006 Seb Ruiz <me@sebruiz.net>               *
 * Originally based off Kipi plugins code, by Gilles Caulier               *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqapplication.h>
#include <tqevent.h>
#include <tqdragobject.h>
#include <tqfileinfo.h>
#include <tqpainter.h>
#include <tqsimplerichtext.h>

#include <klocale.h>

#include "imagelist.h"

using namespace IpodExport;

/////////////////////////////////////////////////////////////////////////////////////////////

ImageList::ImageList( ListType type, TQWidget *parent, const char *name )
    : KListView( parent, name )
    , m_type( type )
{
    if( type == ImageList::UploadType )
    {
        setAcceptDrops( true );
        setDropVisualizer( false );
        addColumn( i18n("Source Album") );
        addColumn( i18n("Image") );
    }
    else if( type == ImageList::IpodType )
    {
        addColumn( i18n("Albums") );
        setRootIsDecorated( true ); // show expand icons
        setSorting( -1 );
        setSelectionMode( TQListView::Single );
    }

    setItemMargin( 3 );
    setResizeMode( TQListView::LastColumn );
    setAllColumnsShowFocus( true );
}

void
ImageList::viewportPaintEvent( TQPaintEvent *e )
{
    if( e ) KListView::viewportPaintEvent( e );

    if( !childCount() && e )
    {
        TQPainter p( viewport() );
        TQString minimumText;

        if( m_type == UploadType )
        {
            minimumText = (i18n(
                    "<div align=center>"
                    "<h3>Upload Queue</h3>"
                        "To create a queue, "
                        "<b>drag</b> images and "
                        "<b>drop</b> them here.<br><br>"
                    "</div>" ) );
        }
        else if( m_type == IpodType )
        {
            minimumText = (i18n(
                    "<div align=center>"
                    "<h3>iPod Albums</h3>"
                        "An album needs to be created before images "
                        "can be transferred to the iPod."
                    "</div>" ) );
        }
        TQSimpleRichText t( minimumText, TQApplication::font() );

        if ( t.width()+30 >= viewport()->width() || t.height()+30 >= viewport()->height() )
            //too big, giving up
            return;

        const uint w = t.width();
        const uint h = t.height();
        const uint x = (viewport()->width() - w - 30) / 2 ;
        const uint y = (viewport()->height() - h - 30) / 2 ;

        p.setBrush( colorGroup().background() );
        p.drawRoundRect( x, y, w+30, h+30, (8*200)/w, (8*200)/h );
        t.draw( &p, x+15, y+15, TQRect(), colorGroup() );
    }
}

void ImageList::dragEnterEvent( TQDragEnterEvent *e )
{
    e->accept( TQUriDrag::canDecode(e) );
}


bool ImageList::acceptDrag( TQDropEvent* e ) const
{
    return TQUriDrag::canDecode( e );
}

void ImageList::contentsDropEvent( TQDropEvent *e )
{
    droppedImagesItems( e );
}

void ImageList::dropEvent( TQDropEvent *e )
{
    droppedImagesItems( e );
}

void ImageList::droppedImagesItems( TQDropEvent *e )
{
    TQStrList strList;
    TQStringList filesPath;

    if ( !TQUriDrag::decode(e, strList) ) return;

    TQStrList stringList;
    TQStrListIterator it(strList);
    char *str;

    while ( (str = it.current()) != 0 )
    {
        TQString filePath = TQUriDrag::uriToLocalFile(str);
        TQFileInfo fileInfo(filePath);

        if( fileInfo.isFile() && fileInfo.exists() )
            filesPath.append( fileInfo.filePath() );

        ++it;
    }

    if( !filesPath.isEmpty() )
       emit addedDropItems( filesPath );
}
