/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2005-07-07
 * Description : a kipi plugin to export images to Flickr web service
 *
 * Copyright (C) 2005-2008 by Vardhman Jain <vardhman at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqlabel.h>
#include <tqframe.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqlayout.h>

// KDE includes.

#include <klocale.h>

// Local includes.

#include "login.h"
#include "login.moc"

namespace KIPIFlickrExportPlugin
{

FlickrLogin::FlickrLogin(TQWidget* parent, const TQString& header,
                         const TQString& _name, const TQString& _passwd)
           : TQDialog(parent)
{
    setSizeGripEnabled(false);

    TQVBoxLayout* vbox = new TQVBoxLayout(this, 5, 5, "vbox");
    m_headerLabel     = new TQLabel(this);
    m_headerLabel->setSizePolicy(TQSizePolicy(TQSizePolicy::Minimum, TQSizePolicy::Fixed));
    m_headerLabel->setText(header);

    TQFrame* hline = new TQFrame(this, "hline");
    hline->setFrameShape(TQFrame::HLine);
    hline->setFrameShadow(TQFrame::Sunken);

    TQGridLayout* centerLayout = new TQGridLayout(0, 1, 1, 5, 5);

    m_nameEdit   = new TQLineEdit(this);
    m_passwdEdit = new TQLineEdit(this);
    m_passwdEdit->setEchoMode(TQLineEdit::Password);

    TQLabel* nameLabel = new TQLabel(this);
    nameLabel->setText(i18n("Username:"));

    TQLabel* passwdLabel = new TQLabel(this);
    passwdLabel->setText(i18n("Password:"));

    centerLayout->addWidget(m_nameEdit,   0, 1);
    centerLayout->addWidget(m_passwdEdit, 1, 1);
    centerLayout->addWidget(nameLabel,    0, 0);
    centerLayout->addWidget(passwdLabel,  1, 0);

    TQHBoxLayout* btnLayout = new TQHBoxLayout(0, 0, 5);
    btnLayout->addItem(new TQSpacerItem(20, 20, TQSizePolicy::Expanding, TQSizePolicy::Minimum));

    TQPushButton *okBtn = new TQPushButton(this);
    okBtn->setAutoDefault(true);
    okBtn->setDefault(true);
    okBtn->setText(i18n("&OK"));

    TQPushButton *cancelBtn = new TQPushButton(this);
    cancelBtn->setText(i18n("&Cancel"));

    btnLayout->addWidget( okBtn );
    btnLayout->addWidget( cancelBtn );

    vbox->addWidget(m_headerLabel);
    vbox->addWidget(hline);
    vbox->addLayout(centerLayout);
    vbox->addLayout(btnLayout);

    resize( TQSize(300, 150).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    m_nameEdit->setText(_name);
    m_passwdEdit->setText(_passwd);

    // ---------------------------------------------------------------

    connect(okBtn, TQT_SIGNAL( clicked() ),
            this, TQT_SLOT( accept() ));

    connect(cancelBtn, TQT_SIGNAL( clicked() ),
            this, TQT_SLOT( reject() ));
}

FlickrLogin::~FlickrLogin()
{
}

TQString FlickrLogin::name() const
{
    return m_nameEdit->text();
}

TQString FlickrLogin::password() const
{
    return m_passwdEdit->text();
}

} // namespace KIPIFlickrExportPlugin
