/* ============================================================
 * File  : calwidget.cpp
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-11-01
 * Description : 
 * 
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

// C++ includes.

#include <iostream>

// TQt includes.
 
#include <tqdatetime.h>
#include <tqpixmap.h>
#include <tqimage.h>
#include <tqpainter.h>

// KDE includes.

#include <kglobal.h>
#include <klocale.h>
#include <kcalendarsystem.h>

// Local includes.

#include "calwidget.h"
#include "calpainter.h"
#include "calsettings.h"

namespace KIPICalendarPlugin
{

CalWidget::CalWidget(TQWidget *parent)
    : TQWidget(parent,0,TQt::WRepaintNoErase|TQt::WResizeNoErase)
{
    setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);
    calPainter_ = 0;
    pix_ = new TQPixmap();
}

CalWidget::~CalWidget()
{
    delete pix_;
    if (calPainter_)
        delete calPainter_;
}

void CalWidget::paintEvent(TQPaintEvent *e)
{
    if (!e || pix_->isNull()) return;
    
    bitBlt(this, 0, 0, pix_, 0, 0, width(), height(), TQt::CopyROP);
}

void CalWidget::recreate()
{
    CalParams& params = CalSettings::instance()->calParams;

    setFixedSize(TQSize(params.width,params.height));
    resize(TQSize(params.width,params.height));
    pix_->resize(params.width,params.height);

    if (!calPainter_)
        calPainter_ = new CalPainter(TQT_TQPAINTDEVICE(pix_));

    calPainter_->setYearMonth(KGlobal::locale()->calendar()->year(TQDate::currentDate()),
                              KGlobal::locale()->calendar()->month(TQDate::currentDate()));
    calPainter_->paint();
    update();
}

}  // NameSpace KIPICalendarPlugin

