/* ============================================================
 * File  : calpainter.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-11-02
 * Description :
 *
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef CALPAINTER_H
#define CALPAINTER_H

// TQt includes.

#include <tqobject.h>
#include <tqvaluelist.h>

// KDE includes.

#include <kurl.h>

// Local includes

#include "calformatter.h"


class TQPaintDevice;
class TQPainter;
class TQString;
class TQTimer;
class TQImage;

namespace KIPICalendarPlugin
{

class CalPainter
{
public:

    CalPainter(TQPaintDevice *pd);
    ~CalPainter();

    void setYearMonth(int year, int month);
    void paint(bool useDeviceMetrics=false);

private:

    TQPaintDevice *pd_;
    int           year_;
    int           month_;
};

class CalBlockPainter : public TQObject
{
    Q_OBJECT
  TQ_OBJECT

public:

    CalBlockPainter(TQObject *parent, int year, int month,
                    const KURL& imagePath, int angle, CalFormatter* formatter, TQPainter *painter);
    ~CalBlockPainter();

signals:

    void signalCompleted();
    void signalProgress(int progress, int total);

private:

    struct Block {
        int x, y;
        int sx, sy;
        int w, h;
    };

    struct Block      *blocks_;
    int                numBlocks_;
    int                currBlock_;
    TQTimer            *timer_;
    TQPainter          *painter_;
    TQImage            *image_;

private slots:

    void slotPaintNextBlock();

};

}  // NameSpace KIPICalendarPlugin

#endif /* CALPAINTER_H */

