/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2004-10-01
 * Description : a kipi plugin to batch process images
 *
 * Copyright (C) 2004-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef BATCHPROCESSIMAGE_H
#define BATCHPROCESSIMAGE_H

// Include files for TQt

#include <tqobject.h>

// Include files for KDE

#include <klistview.h>

namespace KIPIBatchProcessImagesPlugin
{

class BatchProcessImagesList : public KListView
{
Q_OBJECT
  TQ_OBJECT

public:
    BatchProcessImagesList(TQWidget *parent=0, const char *name=0);

signals:
    void addedDropItems(TQStringList filesPath);

protected:
    void dragEnterEvent(TQDragEnterEvent *e);
    void dropEvent(TQDropEvent* e);
    bool acceptDrag(TQDropEvent* e) const;
    void contentsDropEvent(TQDropEvent* e);
    void droppedImagesItems(TQDropEvent *e);
};

}  // NameSpace KIPIBatchProcessImagesPlugin

#endif
