/*
 *   componentSelectionPage.cpp
 *
 *   Copyright (C) 2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "componentSelectionPage.h"

#include <tqpushbutton.h>

#include <kapplication.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <kiconview.h>
#include <klocale.h>

#include "kioskdata.h"

class ComponentViewItem : public TQIconViewItem
{
public:
   ComponentViewItem( TQIconView * parent, const TQString & text, const TQPixmap & icon, const TQString & _id )
    :  TQIconViewItem( parent, text, icon), id(_id)
   {
   }

   TQString id;
};

ComponentSelectionPage::ComponentSelectionPage( KioskData *data, TQWidget* parent, const char* name, WFlags fl )
 : ComponentSelectionPageUI(parent, name, fl), PageWidget(this), m_data(data)
{
   listComponent->setSelectionMode(TQIconView::Single);
   listComponent->setItemsMovable(false);
   listComponent->setSpacing(20);
   listComponent->setGridX(110);
   listComponent->setGridY(75);
   loadComponentList();
   connect(listComponent, TQT_SIGNAL(clicked(TQIconViewItem *)), this, TQT_SLOT(slotComponentActivated(TQIconViewItem *)));
   connect(listComponent, TQT_SIGNAL(returnPressed (TQIconViewItem *)), this, TQT_SLOT(slotComponentActivated(TQIconViewItem *)));
   connect(pbSetup, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotComponentActivated()));
}

ComponentSelectionPage::~ComponentSelectionPage()
{
}

void ComponentSelectionPage::load()
{
}

bool ComponentSelectionPage::save()
{
   KConfig *config = kapp->config();
   config->setGroup("General");
   config->writeEntry("CurrentComponent", currentComponent());
   config->sync();
   return true;
}

void ComponentSelectionPage::setFocus()
{
}

TQString ComponentSelectionPage::subCaption()
{
   return TQString();
}

void ComponentSelectionPage::loadComponentList()
{
    listComponent->clear();
    for(TQStringList::ConstIterator it = m_data->m_componentList.begin();
        it != m_data->m_componentList.end(); ++it)
    {
       ComponentData *data = m_data->m_componentData.find(*it);
       Q_ASSERT(data);
       if (!data) continue;
       TQPixmap icon = DesktopIcon( data->icon, KIcon::SizeMedium );
       new ComponentViewItem(listComponent, data->caption, icon, data->id);
    }
}

bool ComponentSelectionPage::hasSelection()
{
   return !currentComponent().isEmpty();
}

TQString ComponentSelectionPage::currentComponent()
{
   ComponentViewItem *item = static_cast<ComponentViewItem *>(listComponent->firstItem());
   while(item)
   {
      if (item->isSelected())
         return item->id;

      item = static_cast<ComponentViewItem *>(item->nextItem());
   }
   return TQString();
}

void ComponentSelectionPage::setCurrentComponent(const TQString &id)
{
   ComponentViewItem *item = static_cast<ComponentViewItem *>(listComponent->firstItem());
   while(item)
   {
      if (item->id == id)
      {
         listComponent->setSelected(item, true);
         return;
      }
      item = static_cast<ComponentViewItem *>(item->nextItem());
   }
   if (listComponent->firstItem())
      listComponent->setSelected(listComponent->firstItem(), true);
}

void ComponentSelectionPage::slotComponentActivated(TQIconViewItem *item)
{
   if (item)
      emit componentActivated();
}

void ComponentSelectionPage::slotComponentActivated()
{
   if (!currentComponent().isEmpty())
      emit componentActivated();
}

#include "componentSelectionPage.moc"
