/*
 * kdpg.h
 *
 * Copyright (c) 2007 Fabian Wuertz
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KDPKG_H_
#define KDPKG_H_

#include <kdpkgdialog.h>

#include <kde_terminal_interface.h>
#include <kparts/part.h>
#include <process.h>
#include <tqprocess.h>

class kdpkg : public KdpkgDialog
{
	Q_OBJECT
  TQ_OBJECT

	public:
		kdpkg(const TQString &url = TQString(), TQWidget *parent = 0L, const char *name = 0L, const TQStringList &foo = TQStringList());

		void checkArchitecture(TQString);

		TQStringList getVersions(TQString);

		TQStringList fields;
		TQStringList types;
		TQStringList dependencies;
		TQString path;

	private:
		Process* shell;


	public slots:
		virtual void showFields();
		virtual void showDependencies(int);
		virtual void about();
		virtual void install();



};

#endif
