/***************************************************************************
                          scriptobject.cpp - Widget for holding scripts 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* QT INCLUDES */
#include <tqstringlist.h>
#include <tqwidget.h>

/* KDE INCLUDES */
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>


/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include "scriptobject.h"
#include <myprocess.h>
#include <specials.h>

ScriptObject::ScriptObject(TQWidget *a_parent, const char *a_name)
  : TQLabel(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
  if (KommanderWidget::inEditor)
  {
    setPixmap(KGlobal::iconLoader()->loadIcon("shellscript", KIcon::NoGroup, KIcon::SizeMedium));
    setFrameStyle(TQFrame::Box | TQFrame::Plain);
    setLineWidth(1);
    setFixedSize(pixmap()->size());
  }
  else
    setHidden(true);
}

ScriptObject::~ScriptObject()
{
}

TQString ScriptObject::currentState() const
{
  return TQString("default");
}

bool ScriptObject::isKommanderWidget() const
{
  return true;
}

TQStringList ScriptObject::associatedText() const
{
  return KommanderWidget::associatedText();
}

void ScriptObject::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void ScriptObject::setWidgetText(const TQString& a_text)
{
  KommanderWidget::setAssociatedText(a_text);
}

void ScriptObject::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString ScriptObject::populationText() const
{
  return KommanderWidget::populationText();
}

void ScriptObject::populate()
{
  setAssociatedText(KommanderWidget::evalAssociatedText(populationText()));
}

TQString ScriptObject::executeProcess(bool blocking)
{
  int index = ( states().findIndex( currentState()) );
  if (index == -1)
  {
    printError(i18n("Invalid state for associated text."));
    return TQString();
  }
  TQString evalText = m_associatedText[index];

  if ((KommanderWidget::useInternalParser && !evalText.startsWith("#!")) || evalText.startsWith("#!kommander"))
  {
    evalAssociatedText(evalText);
    return global(widgetName() + "_RESULT");
  } else
  {
    MyProcess process(this);
    process.setBlocking(blocking);
    return process.run(evalAssociatedText(evalText));
  }
}

void ScriptObject::execute()
{
  m_params.clear();
  executeProcess(true);
}

void ScriptObject::execute(const TQString& s)
{
  m_params.clear();
  m_params.append(s);
  executeProcess(true);
}

void ScriptObject::execute(const TQString& s1, const TQString& s2)
{
  m_params.clear();
  m_params.append(s1);
  m_params.append(s2);
  executeProcess(true);
}

void ScriptObject::execute(int i)
{
  m_params.clear();
  m_params.append(TQString::number(i));
  executeProcess(true);
}

void ScriptObject::execute(int i, int j)
{
  m_params.clear();
  m_params.append(TQString::number(i));
  m_params.append(TQString::number(j));
  executeProcess(true);
}

void ScriptObject::execute(bool i)
{
  m_params.clear();
  m_params.append(TQString::number(i));
  executeProcess(true);
}

bool ScriptObject::isFunctionSupported(int f)
{
  return f == DCOP::setText || f == DCOP::clear || f == DCOP::execute || f == DCOP::item 
      || f == DCOP::count;
}

TQString ScriptObject::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::setText:
      setAssociatedText(args[0]);
      break;
    case DCOP::clear:
      setAssociatedText(TQString());
      break;
    case DCOP::execute:
      m_params = args;
      return executeProcess(true);
      break;
    case DCOP::item:
    {
      uint index = args[0].toInt();
      return index < m_params.count() ? m_params[index] : TQString();
    }
    case DCOP::count:
      return TQString::number(m_params.count());
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}

#include "scriptobject.moc"
