//
// C++ Interface: popupmenu
//
// Description: 
//
//
// Author: Andras Mantia <amantia@kdewebdev.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef POPUPMENU_H
#define POPUPMENU_H

#include <tqlabel.h>
#include <tqmap.h>
#include <kommanderwidget.h>


class KPopupMenu;

/**
	@author Andras Mantia <amantia@kdewebdev.org>
*/
class PopupMenu : public TQLabel, public KommanderWidget
{
  Q_OBJECT
  TQ_OBJECT
  TQ_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  TQ_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  TQ_PROPERTY(bool KommanderWidget READ isKommanderWidget)
public:
  PopupMenu(TQWidget *parent = 0, const char *name = 0);
  ~PopupMenu();

  virtual bool isKommanderWidget() const;
  virtual TQString currentState() const;
  virtual bool isFunctionSupported(int function);
  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual TQStringList associatedText() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);
  KPopupMenu *menu() {return m_menu;}

public slots:
  virtual void setWidgetText(const TQString &);
  virtual void populate();
  void popup(int x, int y);

private slots:
  void slotMenuItemActivated(int id);

private:
  TQString insertSubmenu(const TQString& title, const TQString &menuWidget, int index, const TQString& icon);

  KPopupMenu *m_menu;
  TQMap<int, TQString> m_associations;
  TQStringList m_params;
};

#endif
