/***************************************************************************
                          lineedit.cpp - Lineedit widget 
                             -------------------
    copyright            : (C) 2002-2003 Marc Britton <consume@optusnet.com.au>
                           (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* QT INCLUDES */
#include <tqlayout.h>
#include <tqevent.h>

/* OTHER INCLUDES */
#include <specials.h>
#include "lineedit.h"
#include <klocale.h>
#include <kommanderplugin.h>

enum functions {
  FirstFunction = 440,
  LE_clearModified,
  LastFunction
};

LineEdit::LineEdit(TQWidget *a_parent, const char *a_name)
	: KLineEdit(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);

  connect(this, TQT_SIGNAL(textChanged(const TQString &)), this,
      TQT_SIGNAL(widgetTextChanged(const TQString &)));
      
  KommanderPlugin::setDefaultGroup(Group::DCOP);
  KommanderPlugin::registerFunction(LE_clearModified, "clearModified(TQString widget)",  i18n("Clear widget modified status."), 1);
}

void LineEdit::showEvent(TQShowEvent *e)
{
  TQLineEdit::showEvent(e);
  emit widgetOpened();
}

void LineEdit::focusInEvent( TQFocusEvent * e)
{
  TQLineEdit::focusInEvent(e);
  emit gotFocus();
}

void LineEdit::focusOutEvent( TQFocusEvent * e)
{
  TQLineEdit::focusOutEvent(e);
  emit lostFocus();
}

TQString LineEdit::currentState() const
{
  return TQString("default");
}

LineEdit::~LineEdit()
{
}

bool LineEdit::isKommanderWidget() const
{
  return true;
}

TQStringList LineEdit::associatedText() const
{
  return KommanderWidget::associatedText();
}

void LineEdit::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void LineEdit::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString LineEdit::populationText() const
{
  return KommanderWidget::populationText();
}

void LineEdit::populate()
{
  TQString txt = KommanderWidget::evalAssociatedText(populationText());
  setWidgetText(txt);
}

void LineEdit::setSelectedWidgetText(const TQString& a_text)
{
  insert(a_text);
}

void LineEdit::setWidgetText(const TQString& a_text)
{
  setText(a_text);
  emit widgetTextChanged(a_text);
}

void LineEdit::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}

bool LineEdit::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::selection || f == DCOP::setSelection ||
    f == DCOP::clear || f == DCOP::setEditable || f == DCOP::geometry || f == DCOP::hasFocus || f == DCOP::getBackgroundColor || f == DCOP::setBackgroundColor || f == DCOP::isModified || (f >= FirstFunction && f <= LastFunction) ;
}

TQString LineEdit::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
      return text();
    case DCOP::setText:
      setWidgetText(args[0]);
      break;
    case DCOP::selection:
      return selectedText();
    case DCOP::setSelection:
      setSelectedWidgetText(args[0]);
      break;
    case DCOP::clear:
      setWidgetText("");
      break;
    case DCOP::setEditable:
      setReadOnly(args[0] == "false" || args[0] == "0");
      break;
    case DCOP::geometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    case DCOP::hasFocus:
      return TQString::number(this->hasFocus());
      break;
    case DCOP::getBackgroundColor:
      return this->paletteBackgroundColor().name();
      break;
    case DCOP::setBackgroundColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      this->setPaletteBackgroundColor(color);
      break;
    }
    case DCOP::isModified:
      return isModified() ? "1" : "0";
      break;
    case LE_clearModified:
      this->clearModified();
      break;
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}



#include "lineedit.moc"
