/***************************************************************************
                         combobox.cpp - Combobox widget 
                             -------------------
    copyright            : (C) 2002-2003 Marc Britton <consume@optusnet.com.au>
                           (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* KDE INCLUDES */
#include <kiconloader.h>
#include <klocale.h>

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>

/* OTHER INCLUDES */
#include <kommanderplugin.h>
#include <specials.h>
#include "combobox.h"

enum Functions {
  FirstFunction = 353, //CHANGE THIS NUMBER TO AN UNIQUE ONE!!!
  popupList,
  LastFunction
};


ComboBox::ComboBox(TQWidget *a_parent, const char *a_name)
  : KComboBox(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);

  connect(this, TQT_SIGNAL(activated(int)), this, TQT_SLOT(emitWidgetTextChanged(int)));

  KommanderPlugin::setDefaultGroup(Group::DCOP);
  KommanderPlugin::registerFunction(popupList, "popupList(TQString widget)",  i18n("Make the ComboBox expose it's list without mousing around."), 1);

}

ComboBox::~ComboBox()
{
}

TQString ComboBox::currentState() const
{
  return TQString("default");
}

bool ComboBox::isKommanderWidget() const
{
  return true;
}

TQStringList ComboBox::associatedText() const
{
  return KommanderWidget::associatedText();
}

void ComboBox::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void ComboBox::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString ComboBox::populationText() const
{
  return KommanderWidget::populationText();
}

void ComboBox::populate()
{
  setWidgetText(KommanderWidget::evalAssociatedText( populationText()));
}

void ComboBox::setWidgetText(const TQString& a_text)
{
  clear();
  insertStringList(TQStringList::split("\n", a_text));
  emit widgetTextChanged(a_text);
}

void ComboBox::emitWidgetTextChanged(int a_index)
{
  emit widgetTextChanged(text(a_index));
}

void ComboBox::showEvent(TQShowEvent *e)
{
    TQComboBox::showEvent( e );
    emit widgetOpened();
}

void ComboBox::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();  
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}


bool ComboBox::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::selection || f == DCOP::setSelection ||
      f == DCOP::currentItem || f == DCOP::setCurrentItem || f == DCOP::item || 
      f == DCOP::removeItem || f == DCOP::insertItem || f == DCOP::insertItems ||
      f == DCOP::addUniqueItem || f == DCOP::clear || f == DCOP::count || f == DCOP::setEditable || f == DCOP::geometry || f == DCOP::hasFocus || f == DCOP::getBackgroundColor || f == DCOP::setBackgroundColor || (f >= FirstFunction && f <= LastFunction);
}

TQString ComboBox::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
      return currentText();
    case DCOP::setText:
      setWidgetText(args[0]);
      break;
    case DCOP::selection:
      return currentText();
    case DCOP::currentItem:
      return TQString::number(currentItem());
    case DCOP::setCurrentItem:
      setCurrentItem(args[0].toUInt());
      break;
    case DCOP::item:
    {
      int i = args[0].toInt();
      if (i >= 0 && i < count()) 
        return text(i);
      break;
    }
    case DCOP::removeItem:
      removeItem(args[0].toInt());
      break;
    case DCOP::insertItem:
      insertItem(args[0], args[1].toInt());
      break;
    case DCOP::insertItems:
      insertStringList(TQStringList::split("\n", args[0]), args[1].toInt());
      break;
    case DCOP::addUniqueItem:
      for (int i=0; i<count(); i++)
        if (text(i) == args[0])
          return TQString();
      insertItem(args[0]);
      break;
    case DCOP::clear:
      clear();
      break;
    case DCOP::count:
      return TQString::number(count());
    case DCOP::setSelection:
    {
      for (int i = 0; i < count(); i++)
        if (text(i) == args[0])
        {
          setCurrentItem(i);
          break;
        }
      break;
    }
    case DCOP::setEditable:
      setEditable(args[0] != "false" && args[0] != "0");
      break;
    case DCOP::getBackgroundColor:
      return this->paletteBackgroundColor().name();
      break;
    case DCOP::setBackgroundColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      this->setPaletteBackgroundColor(color);
      break;
    }
    case popupList:
      TQComboBox::popup();
      break;
    case DCOP::geometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    case DCOP::hasFocus:
      return TQString::number(this->hasFocus());
      break;
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}

#include "combobox.moc"
