/*
 *  Copyright (C) 2007 Dukju Ahn (dukjuahn@gmail.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 */


#ifndef SVN_BLAMEWIDGET_H
#define SVN_BLAMEWIDGET_H

#include <tqwidget.h>
#include <tqdialog.h>
#include <tqvaluelist.h>
class TQVBoxLayout;
class TQListView;
class TQGridLayout;
class TQPushButton;
class TQStringList;

class SvnBlameHolder {
public:
// 	SvnBlameHolder(){};
// 	~SvnBlameHolder(){};
	unsigned int line;
	long int rev;
	TQString date;
	TQString author;
	TQString content;	
};	

class TQListView;

class SvnBlameWidget : public TQWidget {
	Q_OBJECT
  TQ_OBJECT
public:
	SvnBlameWidget( TQWidget * parent = 0, const char * name = 0, bool modal = FALSE, WFlags f = 0 );
	virtual ~SvnBlameWidget();
	void copyBlameData( TQValueList<SvnBlameHolder> *blamelist );
	void show();
	TQListView* outView();
protected:
    TQValueList <SvnBlameHolder> m_blamelist;
    
    TQVBoxLayout *m_layout;
    TQListView *m_listView;
};

class SvnBlameFileSelectDlg : public TQDialog {
    Q_OBJECT
  TQ_OBJECT
public:
    SvnBlameFileSelectDlg( TQWidget *parent = 0L );
    virtual ~SvnBlameFileSelectDlg();
    void setCandidate( TQStringList *modifies );
    TQString selected();
    
protected:
    virtual void accept();
    
private:
    TQGridLayout *m_layout;
    TQListView *m_view;
    TQPushButton *m_okBtn;
    TQPushButton *m_cancelBtn;
    
    TQStringList *m_candidates;
    TQString m_selected;
};

#endif
