/***************************************************************************
*   Copyright (C) 2005 by Jens Dagerbo   *
*   jens.dagerbo@swipnet.se   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
***************************************************************************/

#ifndef KDEVVCSMANAGER_H
#define KDEVVCSMANAGER_H

#include <kdevplugin.h>

#include <tqguardedptr.h>

class TQPopupMenu;
class KAction;
class KDialogBase;
class Context;
class ConfigWidgetProxy;
class VCSManagerWidget;

/**
Please read the README.dox file for more info about this part
*/
class VCSManagerPart: public KDevPlugin
{
	Q_OBJECT
  TQ_OBJECT
public:
	VCSManagerPart(TQObject *parent, const char *name, const TQStringList &args);
	~VCSManagerPart();
	TQString vcsPlugin();
	void loadVCSPlugin();
	void unloadVCSPlugin();

private slots:
	void insertConfigWidget(const KDialogBase *dlg, TQWidget *page, unsigned int pageNo);
	void projectOpened();
	
private:
	TQString m_vcsPluginName;
	ConfigWidgetProxy *m_configProxy;
};

#endif
