/***************************************************************************
 *   Copyright (C) 2005 by Jens Dagerbo   *
 *   jens.dagerbo@swipnet.se   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "vcsmanagerpart.h"

#include <tqtimer.h>
#include <tqpopupmenu.h>
#include <tqwhatsthis.h>

#include <klocale.h>
#include <kaction.h>
#include <kdialogbase.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kdevplugininfo.h>
#include <kdevgenericfactory.h>
#include <kdebug.h>

#include <kdevcore.h>
#include <kdevmainwindow.h>
#include <configwidgetproxy.h>
#include <kdevplugincontroller.h>
#include "domutil.h"

#include "vcsmanagerprojectconfig.h"

typedef KDevGenericFactory<VCSManagerPart> VCSManagerFactory;
KDevPluginInfo data("kdevvcsmanager");
K_EXPORT_COMPONENT_FACTORY( libkdevvcsmanager, VCSManagerFactory( data ) )

#define GLOBALDOC_OPTIONS 1
#define PROJECTDOC_OPTIONS 2

VCSManagerPart::VCSManagerPart(TQObject *parent, const char *name, const TQStringList &/*args*/)
	: KDevPlugin(&data, parent, name ? name : "VCSManagerPart")
{
	kdDebug() << " ********** VCSManagerPart::VCSManagerPart() ************** " << endl;

	setInstance(VCSManagerFactory::instance());
//	setXMLFile("kdevvcsmanager.rc");

	m_configProxy = new ConfigWidgetProxy(core());
	m_configProxy->createProjectConfigPage(i18n("Version Control"), PROJECTDOC_OPTIONS, info()->icon());
	connect(m_configProxy, TQT_SIGNAL(insertConfigWidget(const KDialogBase*, TQWidget*, unsigned int )),
		this, TQT_SLOT(insertConfigWidget(const KDialogBase*, TQWidget*, unsigned int)));

	connect(core(), TQT_SIGNAL(projectOpened()), this, TQT_SLOT(projectOpened()));
}

VCSManagerPart::~VCSManagerPart()
{
	delete m_configProxy;
}

void VCSManagerPart::insertConfigWidget(const KDialogBase *dlg, TQWidget *page, unsigned int pageNo)
{
	switch (pageNo)
	{
		case PROJECTDOC_OPTIONS:
		{
			VCSManagerProjectConfig *w = new VCSManagerProjectConfig(this, page, "project config");
			connect(dlg, TQT_SIGNAL(okClicked()), w, TQT_SLOT(accept()));
			break;
		}
	}
}

void VCSManagerPart::projectOpened()
{
	loadVCSPlugin();
}

void VCSManagerPart::loadVCSPlugin()
{
	unloadVCSPlugin();

	TQDomDocument & dom = *projectDom();
	m_vcsPluginName = DomUtil::readEntry( dom, "/general/versioncontrol" ).stripWhiteSpace();
	if ( m_vcsPluginName.isEmpty() ) return;
	
	TQString constraint = TQString( "DesktopEntryName=='%1'" ).arg( m_vcsPluginName );
	pluginController()->loadPlugin( "KDevelop/VersionControl", constraint );
}

void VCSManagerPart::unloadVCSPlugin()
{
	if ( !m_vcsPluginName.isEmpty() )
	{
		pluginController()->unloadPlugin( m_vcsPluginName );
	}
}

TQString VCSManagerPart::vcsPlugin()
{
	return m_vcsPluginName;
}

#include "vcsmanagerpart.moc"
