#ifndef __TOOLS_CONFIG_H__
#define __TOOLS_CONFIG_H__


#include <tqwidget.h>
#include <tqptrlist.h>
#include <tqpixmap.h>


class TQListBox;
class TQPushButton;
class KDevApplicationTree;

class Entry 
{
public:

  Entry() {};

  TQString name;
  TQString desktopFile;
  TQPixmap icon;

};


class ToolsConfig : public TQWidget
  {
    Q_OBJECT
  TQ_OBJECT

public:

    ToolsConfig(TQWidget *parent = 0, const char *name = 0);


public slots:
   
    void accept();


protected:

    void showEvent(TQShowEvent *);

    void fill();
    void add(const TQString &desktopFile);
    void remove(const TQString &desktopFile);


private slots:

    void checkButtons();

    void toList();
    void toTree();

    void updateList();


private:

    KDevApplicationTree *_tree;
    TQListBox *_list;
    TQPushButton *_toList, *_toTree;

    TQPtrList<Entry> _entries;

  };


#endif
