/* This file is part of the KDE project
   Copyright (C) 2003 Roberto Raggi <roberto@kdevelop.org>
   Copyright (C) 2001 Christoph Cullmann <cullmann@kde.org>
   Copyright (C) 2001 Joseph Wenninger <jowenn@kde.org>
   Copyright (C) 2001 Anders Lund <anders.lund@lund.tdcadsl.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef FILESELECTOR_WIDGET_H
#define FILESELECTOR_WIDGET_H

#include <tqwidget.h>
#include <kfile.h>
#include <kurl.h>
#include <ktoolbar.h>
#include <tqframe.h>
#include <kdiroperator.h>

class KDevMainWindow;
class KDevPartController;
class FileSelectorPart;
class KActionCollection;
class KActionSelector;
class KDirOperator;
class KURLComboBox;
class KHistoryCombo;

namespace KParts
{
    class Part;
}

namespace KTextEditor
{
    class Document;
}

/*
    The KDev file selector presents a directory view, in which the default action is
    to open the activated file.
    Additinally, a toolbar for managing the kdiroperator widget + sync that to
    the directory of the current file is available, as well as a filter widget
    allowing to filter the displayed files using a name filter.
*/

/* I think this fix for not moving toolbars is better */
class KDevFileSelectorToolBar: public KToolBar
{
    Q_OBJECT
  TQ_OBJECT
public:
    KDevFileSelectorToolBar(TQWidget *parent);
    virtual ~KDevFileSelectorToolBar();

    virtual void setMovingEnabled( bool b );
};

class KDevFileSelectorToolBarParent: public TQFrame
{
    Q_OBJECT
  TQ_OBJECT
public:
    KDevFileSelectorToolBarParent(TQWidget *parent);
    ~KDevFileSelectorToolBarParent();
    void setToolBar(KDevFileSelectorToolBar *tb);

private:
    KDevFileSelectorToolBar *m_tb;

protected:
    virtual void resizeEvent ( TQResizeEvent * );
};

class KDevDirOperator: public KDirOperator
{
    Q_OBJECT
  TQ_OBJECT
public:
    KDevDirOperator(FileSelectorPart *part, const KURL &urlName=KURL(), TQWidget *parent=0, const char *name=0)
        :KDirOperator(urlName, parent, name), m_part(part)
    {
    }

protected slots:
    virtual void activatedMenu (const KFileItem *fi, const TQPoint &pos);

private:
    FileSelectorPart *m_part;
};

class KDevFileSelector : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

    friend class KFSConfigPage;

public:
    /* When to sync to current document directory */
    enum AutoSyncEvent { DocumentChanged=1, DocumentOpened=2, GotVisible=4 };

    KDevFileSelector( FileSelectorPart *part, KDevMainWindow *mainWindow=0, KDevPartController *partController=0,
                      TQWidget * parent = 0, const char * name = 0 );
    ~KDevFileSelector();

    void readConfig( KConfig *, const TQString & );
    void writeConfig( KConfig *, const TQString & );
    void setupToolbar( KConfig * );
    void setView( KFile::FileView );
    KDevDirOperator *dirOperator(){ return dir; }
    KActionCollection *actionCollection() { return mActionCollection; };

public slots:
    void slotFilterChange(const TQString&);
    void setDir(KURL);
    void setDir( const TQString& url ) { setDir( KURL( url ) ); };

private slots:
    void cmbPathActivated( const KURL& u );
    void cmbPathReturnPressed( const TQString& u );
    void dirUrlEntered( const KURL& u );
    void dirFinishedLoading();
    void setActiveDocumentDir();
    void viewChanged();
    void btnFilterClick();
    void autoSync();
    void autoSync( KParts::Part * );
	void initialDirChangeHack();
protected:
    void focusInEvent( TQFocusEvent * );
    void showEvent( TQShowEvent * );
    bool eventFilter( TQObject *, TQEvent * );
    KURL activeDocumentUrl();

private:
    class KDevFileSelectorToolBar *toolbar;
    KActionCollection *mActionCollection;
    class KBookmarkHandler *bookmarkHandler;
    KURLComboBox *cmbPath;
    KDevDirOperator * dir;
    class KAction *acSyncDir;
    KHistoryCombo * filter;
    class TQToolButton *btnFilter;

    FileSelectorPart *m_part;
    KDevMainWindow *mainwin;
    KDevPartController *partController;

    TQString lastFilter;
    int autoSyncEvents; // enabled autosync events
    TQString waitingUrl; // maybe display when we gets visible
    TQString waitingDir;
};

/*  @todo anders
    KFSFilterHelper
    A popup widget presenting a listbox with checkable items
    representing the mime types available in the current directory, and
    providing a name filter based on those.
*/

/*
    Config page for file selector.
    Allows for configuring the toolbar, the history length
    of the path and file filter combos, and how to handle
    user closed session.
*/
class KFSConfigPage : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT
public:
    KFSConfigPage( TQWidget* parent=0, const char *name=0, KDevFileSelector *kfs=0);
    virtual ~KFSConfigPage() {};

public slots:
    virtual void apply();
    virtual void reload();
    virtual void slotChanged();

private:
    void init();

    KDevFileSelector *fileSelector;
    bool bDirty;
    //class TQListBox *lbAvailableActions, *lbUsedActions;
    KActionSelector *acSel;
    class TQSpinBox *sbPathHistLength, *sbFilterHistLength;
    class TQCheckBox *cbSyncOpen, *cbSyncActive, *cbSyncShow;
    class TQCheckBox *cbSesLocation, *cbSesFilter;
};


#endif

