/***************************************************************************
 *   Copyright (C) 2001-2002 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _IMPORTDLG_H_
#define _IMPORTDLG_H_

#include "importdlgbase.h"
#include <tqstringlist.h>


class AppWizardPart;

struct InfrastructureCmd{
    bool isOn;
    TQString comment;
    TQString command;
    TQString existingPattern;
};

class ImportDialog : public ImportDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:
    ImportDialog( AppWizardPart *part, TQWidget *parent=0, const char *name=0 );
    ~ImportDialog();

protected:
    virtual void accept();

protected slots:
    virtual void dirChanged();
    virtual void projectTypeChanged(const TQString &type);
    virtual void projectTypeChanged(int type);

private slots:
//    void slotFinishedCheckout( TQString destinationDir );
//    void slotFetchModulesFromRepository();
    void slotProjectNameChanged( const TQString &_text );
private:
//    void scanAvailableVCS();
    void scanLegacyKDevelopProject(const TQString &fileName);
    void scanLegacyStudioProject(const TQString &fileName);
    void scanAutomakeProject(const TQString &dirName);
    void setProjectType(const TQString &type);

    void createProjectInfrastructure();

    TQStringList importNames;
    AppWizardPart *m_part;
    TQString projectVersion;

    TQMap<TQString, InfrastructureCmd> m_infrastructure;
};

#endif
